/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.entity;

import com.hakimen.wandrous.client.mover.IMoverRendererRegister;
import com.hakimen.wandrous.common.entity.projectiles.BombProjectile;
import com.hakimen.wandrous.common.entity.projectiles.SpellCastingProjectile;
import com.hakimen.wandrous.common.spell.mover.ISpellMover;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BombRenderer
extends EntityRenderer<BombProjectile> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wandrous", (String)"textures/item/spell/bomb.png");

    public BombRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(BombProjectile bomb) {
        return TEXTURE;
    }

    public void render(BombProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        List<ISpellMover> movers = SpellCastingProjectile.NBTToMoverList((CompoundTag)pEntity.getEntityData().get(SpellCastingProjectile.MOVER_DATA));
        IMoverRendererRegister.render(movers, pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        Random r = new Random();
        Vec3 location = pEntity.getPosition(pPartialTick);
        if (pEntity.tickCount > 2) {
            for (int i = 0; i < 4; ++i) {
                pEntity.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, location.x + (double)r.nextFloat(-0.25f, 0.25f), location.y + (double)r.nextFloat(-0.25f, 0.25f), location.z + (double)r.nextFloat(-0.25f, 0.25f), 0.0, 0.0, 0.0);
            }
            pEntity.level().addParticle((ParticleOptions)ParticleTypes.FLAME, location.x, location.y, location.z, 0.0, 0.0, 0.0);
            pPoseStack.pushPose();
            pPoseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            pPoseStack.scale(1.25f, 1.25f, 1.25f);
            PoseStack.Pose posestack$pose = pPoseStack.last();
            Matrix4f matrix4f = posestack$pose.pose();
            VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
            BombRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 0.0f, 0.0f, 0, 1);
            BombRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 1.0f, 0.0f, 1, 1);
            BombRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 1.0f, 1.0f, 1, 0);
            BombRenderer.vertex(vertexconsumer, matrix4f, pPackedLight, 0.0f, 1.0f, 0, 0);
            pPoseStack.popPose();
        }
        super.render((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    protected int getBlockLightLevel(BombProjectile pEntity, BlockPos pPos) {
        return super.getBlockLightLevel((Entity)pEntity, pPos);
    }

    private static void vertex(VertexConsumer pConsumer, Matrix4f pPose, int pLightmapUV, float pX, float pY, int pU, int pV) {
        pConsumer.addVertex(pPose, pX - 0.5f, pY - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv((float)pU, (float)pV).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(pLightmapUV, pLightmapUV).setNormal(1.0f, 1.0f, 1.0f);
    }
}

