/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.wandrous.client.ber;

import com.hakimen.wandrous.common.block_entity.GlyphProjectorBlockEntity;
import com.hakimen.wandrous.common.particle.ArcaneKnowledgeParticle;
import com.hakimen.wandrous.common.registers.BlockRegister;
import com.hakimen.wandrous.common.utils.GlyphUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class GlyphProjectorRenderer
implements BlockEntityRenderer<GlyphProjectorBlockEntity> {
    BlockEntityRendererProvider.Context context;

    public GlyphProjectorRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(GlyphProjectorBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemStack stack = pBlockEntity.getInventory().getStackInSlot(0);
        pPoseStack.pushPose();
        pPoseStack.scale(0.75f, 0.75f, 0.75f);
        pPoseStack.translate(0.18, 0.0, 0.18);
        this.context.getBlockRenderDispatcher().renderSingleBlock(((AmethystClusterBlock)BlockRegister.TEALESTITE_CLUSTER.get()).defaultBlockState(), pPoseStack, pBuffer, stack.isEmpty() ? pPackedLight : 0xF000E0, pPackedOverlay);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.8, 0.5);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        this.context.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, 0xFF00E0, pPackedOverlay, pPoseStack, pBuffer, pBlockEntity.getLevel(), 0);
        pPoseStack.popPose();
        if (GlyphUtils.hasGlyph(stack) && !GlyphUtils.isDefault(stack)) {
            float[] rgba = GlyphUtils.getColorFromGlyph(stack);
            pPoseStack.pushPose();
            pPoseStack.translate(0.5, 2.0 + Math.sin(((double)((Object)((Object)pBlockEntity)).hashCode() / 3.14159 + (double)Minecraft.getInstance().level.getGameTime() + (double)pPartialTick) / 16.0) / 8.0, 0.5);
            if (pBlockEntity.getLevel().getRandom().nextFloat() < 0.05f && !Minecraft.getInstance().isPaused()) {
                pBlockEntity.getLevel().addParticle((ParticleOptions)new ArcaneKnowledgeParticle.ArcaneKnowledgeParticleOptions(rgba[0], rgba[1], rgba[2]), (double)((float)pBlockEntity.getBlockPos().getX() + 0.0f + pBlockEntity.getLevel().getRandom().nextFloat()), (double)((float)pBlockEntity.getBlockPos().getY() + 1.0f + pBlockEntity.getLevel().getRandom().nextFloat()), (double)((float)pBlockEntity.getBlockPos().getZ() + 0.0f + pBlockEntity.getLevel().getRandom().nextFloat()), 0.0, 0.0, 0.0);
            }
            pPoseStack.rotateAround(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(Minecraft.getInstance().cameraEntity.getYRot() * -1.0f), 0.0f), 0.0f, 0.0f, 0.0f);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)GlyphUtils.getGlyphTextureFromStack(stack)));
            GlyphProjectorRenderer.vertex(vertexconsumer, pPoseStack, 0xF000E0, 0.0f, 0.0f, 0.0f, 1.0f, rgba[0], rgba[1], rgba[2], rgba[3]);
            GlyphProjectorRenderer.vertex(vertexconsumer, pPoseStack, 0xF000E0, 1.0f, 0.0f, 1.0f, 1.0f, rgba[0], rgba[1], rgba[2], rgba[3]);
            GlyphProjectorRenderer.vertex(vertexconsumer, pPoseStack, 0xF000E0, 1.0f, 1.0f, 1.0f, 0.0f, rgba[0], rgba[1], rgba[2], rgba[3]);
            GlyphProjectorRenderer.vertex(vertexconsumer, pPoseStack, 0xF000E0, 0.0f, 1.0f, 0.0f, 0.0f, rgba[0], rgba[1], rgba[2], rgba[3]);
            pPoseStack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(GlyphProjectorBlockEntity pBlockEntity) {
        return true;
    }

    public boolean shouldRender(GlyphProjectorBlockEntity pBlockEntity, Vec3 pCameraPos) {
        return true;
    }

    public AABB getRenderBoundingBox(GlyphProjectorBlockEntity blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(0.0, 2.0, 0.0);
    }

    private static void vertex(VertexConsumer pConsumer, PoseStack poseStack, int pLightmapUV, float pX, float pY, float pU, float pV, float r, float g, float b, float alpha) {
        pConsumer.addVertex(poseStack.last().pose(), pX - 0.5f, pY - 0.25f, 0.0f).setColor(r, g, b, alpha).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(pLightmapUV, pLightmapUV).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
    }
}

