/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.config.entry.EntryBaseEntry;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class EntryWidgetBuilder<T>
extends WidgetBuilder<Map.Entry<String, T>> {
    private final EntryBaseEntry<T> config;
    @Nullable
    private EditBox keyWidget;
    @Nullable
    private WidgetBuilder<T> valueBuilder;

    public EntryWidgetBuilder(EntryBaseEntry<T> config) {
        super(config);
        this.config = config;
    }

    @Override
    public void addCustomElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        this.keyWidget = new EditBox(((Minecraft)EntryWidgetBuilder.CLIENT.get()).font, x, y, width / 2 - 5, height, (Component)Component.empty());
        this.keyWidget.setValue((String)((Map.Entry)this.config.getValue()).getKey());
        this.keyWidget.setResponder(s -> this.config.setValue(new AbstractMap.SimpleEntry((String)s, ((Map.Entry)this.config.getValue()).getValue())));
        appender.accept((AbstractWidget)this.keyWidget);
        this.valueBuilder = WidgetBuilderManager.get(this.config.newValueInstance());
        this.valueBuilder.addCustomElements(appender, x + width / 2, y, width / 2, height);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.keyWidget != null) {
            this.keyWidget.visible = visible;
            this.keyWidget.setY(y);
        }
        if (this.valueBuilder != null) {
            this.valueBuilder.update(visible, y);
        }
    }

    @Override
    public void refresh() {
        if (this.keyWidget != null) {
            this.keyWidget.setValue((String)((Map.Entry)this.config.getValue()).getKey());
        }
        if (this.valueBuilder != null) {
            this.valueBuilder.refresh();
        }
    }
}

