/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.EntryStringEntry;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;

public class MapStringEntry
extends MapBaseEntry<String> {
    public MapStringEntry(String nameKey, Map<String, String> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<String> getValueCodec() {
        return Codec.STRING;
    }

    @Override
    public IConfigEntry<Map.Entry<String, String>> newSingleInstance(String value, final String key, final Runnable reload) {
        return new EntryStringEntry(this.nameKey, new AbstractMap.SimpleEntry<String, String>(key, value)){

            @Override
            public void reset() {
                ((Map)MapStringEntry.this.getValue()).remove(key);
                reload.run();
            }

            @Override
            public void setValue(Map.Entry<String, String> value) {
                if (!Objects.equals(((Map.Entry)this.value).getKey(), value.getKey())) {
                    ((Map)MapStringEntry.this.getValue()).remove(((Map.Entry)this.value).getKey());
                    ((Map)MapStringEntry.this.getValue()).put(value.getKey(), value.getValue());
                } else if (!Objects.equals(((Map.Entry)this.value).getValue(), value.getValue())) {
                    ((Map)MapStringEntry.this.getValue()).put((String)((Map.Entry)this.value).getKey(), value.getValue());
                }
                super.setValue(value);
            }
        };
    }

    @Override
    public String newValue() {
        return "";
    }

    @Override
    public ConfigType<Map<String, String>> getType() {
        return ConfigTypes.MAP_STRING;
    }

    @Override
    public IConfigEntry<Map<String, String>> newInstance() {
        return new MapStringEntry(this.nameKey, (Map)this.defaultValue).visible(this.visible).json(this.jsonKey);
    }
}

