/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.teams;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.NameCache;
import shetiphian.core.platform.Services;
import shetiphian.core.self.network.PacketNameSyncTeam;
import shetiphian.core.self.teams.PacketTeamSync;
import shetiphian.core.self.teams.PlayerTeam;

public class TeamHelper {
    static final Map<String, PlayerTeam> TEAMS = new HashMap<String, PlayerTeam>();
    static final Map<UUID, PlayerTeam> PLAYER_TEAM = new HashMap<UUID, PlayerTeam>();
    private static final SavedData.Factory<TeamSaveData> SAVE_DATA_TYPE = new SavedData.Factory(TeamSaveData::new, TeamSaveData::load, null);
    private static TeamSaveData SAVE_INSTANCE;

    public static Set<String> getTeams() {
        return TEAMS.keySet();
    }

    public static boolean doesTeamExist(String id) {
        return TEAMS.containsKey(id);
    }

    public static Component getTeamDisplayName(String id) {
        return TeamHelper.doesTeamExist(id) ? TEAMS.get(id).getDisplayName() : Component.literal((String)((String)NameCache.FALLBACK.apply((Object)id)));
    }

    public static PlayerTeam getTeam(String id) {
        return TEAMS.get(id);
    }

    public static PlayerTeam getTeam(Player player) {
        return TeamHelper.getTeam(player.getUUID());
    }

    public static PlayerTeam getTeam(UUID player) {
        return PLAYER_TEAM.getOrDefault(player, null);
    }

    static List<UUID> deleteTeam(String id) {
        PlayerTeam team = TEAMS.get(id);
        if (team != null) {
            List<UUID> members = team.getMembers();
            members.forEach(PLAYER_TEAM::remove);
            TEAMS.remove(id);
            TeamHelper.markDirty();
            Services.NETWORK.sendToIdList(new PacketTeamSync(team, null), members);
            TeamHelper.syncDisplayName(id, (String)NameCache.FALLBACK.apply((Object)id));
            return members;
        }
        return Collections.emptyList();
    }

    static void syncDisplayName(String teamId, String display) {
        NameCache.setTeamName(teamId, display);
        Services.NETWORK.sendToAll(new PacketNameSyncTeam(display, teamId));
    }

    public static void load(MinecraftServer server, ServerLevel world) {
        SAVE_INSTANCE = (TeamSaveData)world.getDataStorage().computeIfAbsent(SAVE_DATA_TYPE, "shetiphiancore_teams");
    }

    public static void markDirty() {
        SAVE_INSTANCE.setDirty();
    }

    public static class TeamSaveData
    extends SavedData {
        public CompoundTag save(CompoundTag fileNBT, HolderLookup.Provider provider) {
            ShetiPhianCore.LOGGER.debug("Saving Teams Data");
            TEAMS.forEach((teamId, team) -> fileNBT.put(teamId, (Tag)team.write(provider)));
            ShetiPhianCore.LOGGER.info("Teams Data Saved");
            return fileNBT;
        }

        public static TeamSaveData load(CompoundTag fileNBT, HolderLookup.Provider provider) {
            ShetiPhianCore.LOGGER.debug("Loading Teams Data");
            PLAYER_TEAM.clear();
            TEAMS.clear();
            for (String teamId : fileNBT.getAllKeys()) {
                if (!(fileNBT.get(teamId) instanceof CompoundTag)) continue;
                PlayerTeam team = PlayerTeam.load(teamId, fileNBT.getCompound(teamId), provider);
                TEAMS.put(teamId, team);
                team.getMembers().forEach(member -> PLAYER_TEAM.put((UUID)member, team));
            }
            ShetiPhianCore.LOGGER.info("Teams Data Loaded");
            return new TeamSaveData();
        }
    }
}

