/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.modintegration.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.tileentity.TileEntityExtendedRedstone;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.JadeIds;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public final class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation CONFIG_RGB16 = ShetiPhianCore.RESOURCE.apply("hud.rgb16");
    private static final ResourceLocation CONFIG_REDSTONE = ShetiPhianCore.RESOURCE.apply("hud.redstone");

    public void register(IWailaCommonRegistration registration) {
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(CONFIG_RGB16, true);
        registration.addConfig(CONFIG_REDSTONE, true);
        registration.registerBlockComponent((IComponentProvider)ComponentProvider.INSTANCE, Block.class);
    }

    public static class ComponentProvider
    implements IBlockComponentProvider {
        static final ComponentProvider INSTANCE = new ComponentProvider();
        private static final ResourceLocation INFO_PROVIDER_ID = ShetiPhianCore.RESOURCE.apply("hud");
        private static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.REDSTONE);

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            RGB16 rgb16;
            BlockEntity tile = accessor.getBlockEntity();
            if (config.get(CONFIG_RGB16) && tile instanceof IRGB16_Tile && (rgb16 = ((IRGB16_Tile)tile).getRGB16(null)) != null) {
                tooltip.add((Component)Component.literal((String)String.format("\u00a77RGB16: %s \u00a7f[\u00a77%d\u00a7f]", rgb16.getTooltip(), rgb16.getIndex())));
            }
            if (config.get(JadeIds.MC_REDSTONE) && tile instanceof TileEntityExtendedRedstone) {
                IElementHelper elements = IElementHelper.get();
                IElement icon = elements.item(REDSTONE, 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f)).message(null);
                tooltip.add(icon);
                tooltip.append((Component)Component.translatable((String)"tooltip.jade.power", (Object[])new Object[]{String.format("\u00a7f%d", ((TileEntityExtendedRedstone)tile).getRSPower())}));
                if (config.get(CONFIG_REDSTONE)) {
                    tooltip.add(icon);
                    tooltip.append((Component)Component.translatable((String)"hud.shetiphiancore.extended_power").append((Component)Component.literal((String)String.format(" \u00a7f%d", ((TileEntityExtendedRedstone)tile).getExPower()))));
                }
            }
        }

        public ResourceLocation getUid() {
            return INFO_PROVIDER_ID;
        }
    }
}

