/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.client.gui.EntityGuiItem;

public class GuiItemRenderer
extends ItemEntityRenderer {
    private final ItemRenderer itemRenderer;
    private final RandomSource random = RandomSource.create();

    public GuiItemRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(ItemEntity entity, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.pushPose();
        ItemStack stack = entity.getItem();
        if (stack.getCount() > 1 && !this.shouldSpreadItems()) {
            stack = stack.copyWithCount(1);
        }
        this.random.setSeed((long)GuiItemRenderer.getSeedForItemStack((ItemStack)stack));
        BakedModel bakedmodel = this.itemRenderer.getModel(stack, entity.level(), null, entity.getId());
        boolean is3D = bakedmodel.isGui3d();
        float yPos = this.shouldBob() ? Mth.sin((float)(((float)entity.getAge() + partialTicks) / 10.0f + entity.bobOffs)) * 0.1f + 0.1f : 0.0f;
        float yScale = bakedmodel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        matrixStack.translate(0.0f, yPos + 0.25f * yScale, 0.0f);
        float spin = entity.getSpin(partialTicks);
        matrixStack.mulPose(Axis.YP.rotation(spin));
        GuiItemRenderer.renderMultipleFromCount((ItemRenderer)this.itemRenderer, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)packedLight, (ItemStack)stack, (BakedModel)bakedmodel, (boolean)is3D, (RandomSource)this.random);
        matrixStack.popPose();
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return false;
    }

    public static void render(EntityGuiItem entityGuiItem, GuiGraphics graphics, boolean spin, float rotateX, float rotateY, float rotateZ, float translateX, float translateY, float translateZ, float scaleX, float scaleY, float scaleZ) {
        Lighting.setupForEntityInInventory();
        PoseStack matrixstack = graphics.pose();
        matrixstack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixstack.translate(translateX, translateY, translateZ);
        matrixstack.scale(scaleX, scaleY, scaleZ);
        matrixstack.mulPose(Axis.XP.rotationDegrees(rotateX));
        matrixstack.mulPose(Axis.YP.rotationDegrees(rotateY));
        matrixstack.mulPose(Axis.ZP.rotationDegrees(rotateZ));
        if (spin) {
            int value = (int)(System.currentTimeMillis() / 30L % 360L);
            matrixstack.mulPose(Axis.YP.rotationDegrees((float)value));
        }
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        dispatcher.render((Entity)entityGuiItem, 0.0, 0.01, 0.0, 0.0f, 0.0f, matrixstack, (MultiBufferSource)graphics.bufferSource(), 0xF000F0);
        graphics.flush();
        matrixstack.popPose();
        Lighting.setupFor3DItems();
    }
}

