/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.phys.BlockHitResult;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.NameCache;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.platform.Services;
import shetiphian.core.self.Configs;
import shetiphian.core.self.teams.PacketTeamSync;
import shetiphian.core.self.teams.TeamCommand;
import shetiphian.core.self.teams.TeamHelper;

public class EventHandler {
    private static final Map<Block, Block> LOG_LOOKUP = new HashMap<Block, Block>();
    private static boolean GENERATE_LOG_LOOKUP = true;
    public static final CauldronInteraction RGB16WASH = (state, world, pos, player, hand, stack) -> {
        IRGB16_Item item;
        Item patt0$temp = stack.getItem();
        if (!(patt0$temp instanceof IRGB16_Item) || (item = (IRGB16_Item)patt0$temp).getRGB16(stack).getIndex() == item.getStartingIndex(stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide()) {
            ItemStack washedStack = stack.copy();
            washedStack.setCount(1);
            if (item.setRGB16(washedStack, new ImmutableRGB16(item.getStartingIndex(washedStack)))) {
                stack.shrink(1);
                if (!player.getAbilities().instabuild) {
                    LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)world, (BlockPos)pos);
                }
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, washedStack);
                } else if (!player.getInventory().add(washedStack)) {
                    player.drop(washedStack, false);
                }
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
    };

    protected void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        TeamCommand.register(dispatcher, buildContext);
    }

    protected InteractionResult onApplyBonemeal(BlockState state, Level world, BlockPos pos) {
        if (state != null) {
            GrassBlock grassBlock;
            Block block = state.getBlock();
            if (Configs.CORE_EDITS.bonemealRestoresBark.get().booleanValue()) {
                if (GENERATE_LOG_LOOKUP) {
                    GENERATE_LOG_LOOKUP = false;
                    Function<Block, Optional<BlockState>> stripper = Services.COMMON.getLogStrippingProcessor(Items.DIAMOND_AXE, world);
                    if (stripper != null) {
                        TagHelper.BLOCKS.getCollection((TagKey<Block>)BlockTags.LOGS).forEach(unstripped -> {
                            try {
                                ((Optional)stripper.apply((Block)unstripped)).ifPresent(result -> LOG_LOOKUP.compute(result.getBlock(), (stripped, cached) -> {
                                    ResourceKey uKey;
                                    if (cached == null) {
                                        return unstripped;
                                    }
                                    ResourceKey sKey = BuiltInRegistries.BLOCK.getResourceKey(stripped).orElse(null);
                                    ResourceKey cKey = BuiltInRegistries.BLOCK.getResourceKey(cached).orElse(null);
                                    if (sKey != null && cKey != null && !sKey.location().getNamespace().equals(cKey.location().getNamespace()) && (uKey = (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(unstripped).orElse(null)) != null && sKey.location().getNamespace().equals(uKey.location().getNamespace())) {
                                        return unstripped;
                                    }
                                    return cached;
                                }));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                }
                if (LOG_LOOKUP.containsKey(block)) {
                    BlockState unstripped2 = LOG_LOOKUP.get(block).defaultBlockState();
                    state.getProperties().forEach(property -> this.copyProperty((Property)property, state, unstripped2));
                    Helpers.setBlock((LevelAccessor)world, pos, unstripped2, true);
                    return InteractionResult.SUCCESS;
                }
            }
            if (block instanceof IBonemealable) {
                IBonemealable bonemealable = (IBonemealable)block;
                if (bonemealable.canGrow(world, pos, state, world.isClientSide())) {
                    if (!world.isClientSide() && bonemealable.canUseBonemeal(world, world.random, pos, state)) {
                        bonemealable.grow(world, world.random, pos, state);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (Configs.CORE_EDITS.bonemealFlowerFix.get().booleanValue() && block instanceof GrassBlock && (grassBlock = (GrassBlock)block).isValidBonemealTarget((LevelReader)world, pos, state)) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    if (grassBlock.isBonemealSuccess(world, world.random, pos, state)) {
                        this.growModFlowers(serverWorld, world.random, pos, (Block)grassBlock);
                        grassBlock.performBonemeal(serverWorld, world.random, pos, state);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private <T extends Comparable<T>> void copyProperty(Property<T> property, BlockState stripped, BlockState unstripped) {
        if (unstripped.hasProperty(property)) {
            unstripped.setValue(property, stripped.getValue(property));
        }
    }

    private void growModFlowers(ServerLevel world, RandomSource random, BlockPos pos, Block blockInstance) {
        int maxToPlace = 1 + random.nextInt(4) + random.nextInt(4);
        int placed = 0;
        BlockPos blockPos = pos.above();
        block0: for (int attempt = 0; attempt < 128; ++attempt) {
            int listIndex;
            List list;
            BlockPos posPlace = blockPos;
            for (int pass = 0; pass < attempt / 16; ++pass) {
                if (!world.getBlockState((posPlace = posPlace.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is(blockInstance) || world.getBlockState(posPlace).isCollisionShapeFullBlock((BlockGetter)world, posPlace)) continue block0;
            }
            if (!world.getBlockState(posPlace).isAir() || random.nextInt(8) != 0 || (list = ((Biome)world.getBiome(posPlace).value()).getGenerationSettings().getFlowerFeatures()).size() <= 1 || (listIndex = random.nextInt(list.size())) == 0) continue;
            Holder registryEntry = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(listIndex)).config()).feature();
            ((PlacedFeature)registryEntry.value()).place((WorldGenLevel)world, world.getChunkSource().getGenerator(), random, posPlace);
            if (++placed < maxToPlace) continue;
            return;
        }
    }

    protected void onItemCrafted(Player player, ItemStack result, Container inv) {
        IRGB16_Item rgb16Item;
        Item item;
        if (!result.isEmpty() && (item = result.getItem()) instanceof IRGB16_Item && (rgb16Item = (IRGB16_Item)item).enableDyeRecipe(result) && rgb16Item.dyeUseChance(result)) {
            RandomSource rand = player.level().getRandom();
            rand.setSeed((long)RGB16StackHelper.readColor(result));
            int counter = 0;
            for (int index = 0; index < inv.getContainerSize(); ++index) {
                ItemStack invStack = inv.getItem(index);
                if (invStack.isEmpty() || !invStack.isStackable() || !DyeHelper.isDye(invStack) || invStack.getItem().hasCraftingRemainingItem()) continue;
                double chance = rgb16Item.getDyeUseChance(result, invStack, counter);
                ++counter;
                if (!(chance < 1.0) || chance != 0.0 && !(rand.nextDouble() >= chance)) continue;
                invStack.grow(1);
            }
        }
    }

    protected InteractionResult onPlayerRightClickBlock(Player player, Level world, BlockPos pos, InteractionHand hand, BlockHitResult hitResult) {
        BlockState state;
        Block block;
        ItemStack stack;
        if (player != null && hitResult != null && !(stack = player.getItemInHand(hand)).isEmpty() && (block = (state = world.getBlockState(pos)).getBlock()) instanceof IRGB16_Block) {
            IRGB16_Block rgb16Block = (IRGB16_Block)block;
            String dyeName = DyeHelper.getDyeName(stack);
            if (!Strings.isNullOrEmpty((String)dyeName) && rgb16Block.recolorBlock(state, (LevelAccessor)world, pos, player, hand, hitResult.getDirection(), hitResult.getLocation(), dyeName)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected void onEntityJoinedWorld(Entity entity) {
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity;
            Services.NETWORK.sendToPlayer((CustomPacketPayload)new PacketTeamSync(TeamHelper.getTeam((Player)player2), (Player)player2), player2);
            NameCache.setPlayerName(player2);
            PlayerConfigs.preformSync(PlayerConfigs.Side.SERVER, (Player)player2);
        } else if (entity instanceof Player && (player = (Player)entity).level().isClientSide()) {
            Services.NETWORK.setClientReady(true);
            PlayerConfigs.preformSync(PlayerConfigs.Side.CLIENT, player);
        }
    }

    protected void onEntityLeaveWorld(Entity entity) {
        if (!(entity instanceof ServerPlayer) && entity instanceof Player) {
            Services.NETWORK.setClientReady(false);
        }
    }
}

