/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractContainer
extends AbstractContainerMenu {
    protected AbstractContainer(MenuType<?> type, int id) {
        super(type, id);
    }

    protected boolean allowOverflow() {
        return false;
    }

    protected boolean canOverflowInto(ItemStack stack, Slot slot) {
        return true;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        ItemStack itemInSlot;
        Slot slot;
        boolean handled = false;
        int index = startIndex;
        if (fromLast) {
            index = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (fromLast ? index >= startIndex : index < endIndex)) {
                slot = (Slot)this.slots.get(index);
                itemInSlot = slot.getItem();
                if (!itemInSlot.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemInSlot)) {
                    int maxStackSize;
                    int combinedSize = itemInSlot.getCount() + stack.getCount();
                    if (combinedSize <= (maxStackSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize()))) {
                        stack.setCount(0);
                        itemInSlot.setCount(combinedSize);
                        slot.setChanged();
                        handled = true;
                    } else if (itemInSlot.getCount() < maxStackSize) {
                        stack.shrink(maxStackSize - itemInSlot.getCount());
                        itemInSlot.setCount(maxStackSize);
                        slot.setChanged();
                        handled = true;
                    }
                }
                if (fromLast) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (!stack.isEmpty()) {
            if (handled && !this.allowOverflow()) {
                return false;
            }
            int n = index = fromLast ? endIndex - 1 : startIndex;
            while (fromLast ? index >= startIndex : index < endIndex) {
                slot = (Slot)this.slots.get(index);
                itemInSlot = slot.getItem();
                if (itemInSlot.isEmpty() && slot.mayPlace(stack) && this.canOverflowInto(stack, slot)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.set(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.set(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    handled = true;
                    break;
                }
                if (fromLast) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (!stack.isEmpty() && handled && !this.allowOverflow()) {
            return false;
        }
        return handled;
    }
}

