/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public abstract class AbstractShapedRecipe
extends ShapedRecipe {
    protected final ShapedRecipePattern pattern;
    protected final ItemStack result;
    protected final String group;
    protected final CraftingBookCategory category;
    protected final boolean showNotification;

    public AbstractShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = result;
        this.showNotification = showNotification;
    }

    public abstract RecipeSerializer<?> getSerializer();

    public static abstract class Serializer<T extends AbstractShapedRecipe>
    implements RecipeSerializer<T> {
        private MapCodec<T> CODEC;
        private StreamCodec<RegistryFriendlyByteBuf, T> STREAM_CODEC;

        protected abstract T createInstance(String var1, CraftingBookCategory var2, ShapedRecipePattern var3, ItemStack var4, boolean var5);

        public MapCodec<T> codec() {
            if (this.CODEC == null) {
                this.CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, this::createInstance));
            }
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            if (this.STREAM_CODEC == null) {
                this.STREAM_CODEC = StreamCodec.of((buffer, recipe) -> {
                    buffer.writeUtf(recipe.group);
                    buffer.writeEnum((Enum)recipe.category);
                    ShapedRecipePattern.STREAM_CODEC.encode(buffer, (Object)recipe.pattern);
                    ItemStack.STREAM_CODEC.encode(buffer, (Object)recipe.result);
                    buffer.writeBoolean(recipe.showNotification);
                }, buffer -> {
                    String group = buffer.readUtf();
                    CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
                    ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode(buffer);
                    ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buffer);
                    boolean showNotification = buffer.readBoolean();
                    return this.createInstance(group, category, pattern, result, showNotification);
                });
            }
            return this.STREAM_CODEC;
        }
    }
}

