/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import shetiphian.core.ShetiPhianCore;

public class ReflectionHelper {
    public static Method getMethod(Class<?> clazz, String devName, Class<?> ... parameterTypes) {
        return ReflectionHelper.getMethod(clazz, devName, null, parameterTypes);
    }

    public static Method getMethod(Class<?> clazz, String devName, String srgName, Class<?> ... parameterTypes) {
        if (!Strings.isNullOrEmpty((String)srgName)) {
            try {
                return clazz.getDeclaredMethod(srgName, parameterTypes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return clazz.getDeclaredMethod(devName, parameterTypes);
        }
        catch (NoSuchMethodException exception) {
            ShetiPhianCore.LOGGER.error("Unable to locate method {} in {}", new Object[]{devName, clazz.getName(), exception});
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String devName) {
        return ReflectionHelper.getField(clazz, devName, null);
    }

    public static Field getField(Class<?> clazz, String devName, String srgName) {
        if (!Strings.isNullOrEmpty((String)srgName)) {
            try {
                return clazz.getDeclaredField(srgName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return clazz.getDeclaredField(devName);
        }
        catch (NoSuchFieldException exception) {
            ShetiPhianCore.LOGGER.error("Unable to locate field {} in {}", new Object[]{devName, clazz.getName(), exception});
            return null;
        }
    }

    public static <T, E> T getValue(Class<? super E> clazz, E instance, String devName) {
        return ReflectionHelper.getValue(clazz, instance, devName, null);
    }

    public static <T, E> T getValue(Class<? super E> clazz, E instance, String devName, String srgName) {
        Field field = ReflectionHelper.getField(clazz, devName, srgName);
        if (field != null) {
            try {
                field.setAccessible(true);
                return (T)field.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                ShetiPhianCore.LOGGER.error("Unable to access field {} in {}", new Object[]{devName, clazz.getName(), exception});
            }
        }
        return null;
    }

    public static <T, E> boolean setValue(Class<? super E> clazz, E instance, T value, String devName) {
        return ReflectionHelper.setValue(clazz, instance, value, devName, null);
    }

    public static <T, E> boolean setValue(Class<? super E> clazz, E instance, T value, String devName, String srgName) {
        Field field = ReflectionHelper.getField(clazz, devName, srgName);
        if (field != null) {
            try {
                field.setAccessible(true);
                field.set(instance, value);
                return true;
            }
            catch (IllegalAccessException exception) {
                ShetiPhianCore.LOGGER.error("Unable to access field {} in {}", new Object[]{devName, clazz.getName(), exception});
            }
        }
        return false;
    }
}

