/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.collect.HashBasedTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.network.IConfigWrapper;

public class PlayerConfigs {
    private static final Set<BiConsumer<Side, Player>> SYNC_PROCESSORS = new HashSet<BiConsumer<Side, Player>>();
    private static final HashBasedTable<UUID, ResourceLocation, Object> SYNCED_CONFIG_VALUES = HashBasedTable.create();
    private static final HashMap<ResourceLocation, IConfigWrapper> WRAPPERS = new HashMap();
    private static final UUID SELF = new UUID(0L, 0L);

    public static void registerSyncProcessor(BiConsumer<Side, Player> consumer) {
        SYNC_PROCESSORS.add(consumer);
    }

    public static void preformSync(Side side, Player player) {
        SYNC_PROCESSORS.forEach(consumer -> consumer.accept(side, player));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConfigWrapper(ResourceLocation identifier, IConfigWrapper wrapper) {
        HashMap<ResourceLocation, IConfigWrapper> hashMap = WRAPPERS;
        synchronized (hashMap) {
            WRAPPERS.put(identifier, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IConfigWrapper getConfigWrapper(ResourceLocation identifier) {
        HashMap<ResourceLocation, IConfigWrapper> hashMap = WRAPPERS;
        synchronized (hashMap) {
            return WRAPPERS.getOrDefault(identifier, null);
        }
    }

    public static void setPlayerControlled(Player player, ResourceLocation identifier, Object object) {
        if (!player.level().isClientSide()) {
            PlayerConfigs.setConfigs(player.getUUID(), identifier, object);
        }
    }

    public static void setServerControlled(ResourceLocation identifier, Object object) {
        PlayerConfigs.setConfigs(SELF, identifier, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConfigs(UUID uuid, ResourceLocation identifier, Object object) {
        HashBasedTable<UUID, ResourceLocation, Object> hashBasedTable = SYNCED_CONFIG_VALUES;
        synchronized (hashBasedTable) {
            SYNCED_CONFIG_VALUES.put((Object)uuid, (Object)identifier, object);
        }
    }

    public static <T> T getPlayerConfig(Player player, ResourceLocation identifier, T fallback, Supplier<T> clientConfig) {
        if (player.level().isClientSide()) {
            return clientConfig.get();
        }
        return PlayerConfigs.getConfig(player.getUUID(), identifier, fallback);
    }

    public static <T> T getServerConfig(ResourceLocation identifier, T configDefault) {
        return PlayerConfigs.getConfig(SELF, identifier, configDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getConfig(UUID uuid, ResourceLocation identifier, T fallback) {
        Object object;
        HashBasedTable<UUID, ResourceLocation, Object> hashBasedTable = SYNCED_CONFIG_VALUES;
        synchronized (hashBasedTable) {
            object = SYNCED_CONFIG_VALUES.get((Object)uuid, (Object)identifier);
        }
        if (fallback.getClass().isInstance(object)) {
            try {
                return (T)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fallback;
    }

    public static enum Side {
        CLIENT,
        SERVER;

    }
}

