/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ParticleHelper {
    protected static ParticleHelper INSTANCE = new ParticleHelper();

    public static boolean addLandingEffects(BlockState state, ServerLevel world, Entity entity, int numberOfParticles, BlockState particles) {
        return particles == null || particles.isAir() || state != particles && INSTANCE.landing(state, world, entity, numberOfParticles, particles);
    }

    protected boolean landing(BlockState state, ServerLevel world, Entity entity, int numberOfParticles, BlockState particles) {
        world.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, particles), entity.getX(), entity.getY(), entity.getZ(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
        return true;
    }

    public static boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity, BlockState particles) {
        return particles == null || particles.isAir() || state != particles && INSTANCE.running(state, world, pos, entity, particles);
    }

    protected boolean running(BlockState state, Level world, BlockPos pos, Entity entity, BlockState particles) {
        Vec3 vec3d = entity.getDeltaMovement();
        EntityDimensions size = entity.getDimensions(entity.getPose());
        world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, particles), entity.getX() + ((double)world.random.nextFloat() - 0.5) * (double)size.width(), entity.getY() + 0.1, entity.getZ() + ((double)world.random.nextFloat() - 0.5) * (double)size.width(), vec3d.x * -4.0, 1.5, vec3d.z * -4.0);
        return true;
    }

    public static boolean addHitEffects(BlockState state, Level world, BlockPos pos, Direction side, Object particleEngine, BlockState particles) {
        return particles == null || particles.isAir() || state != particles && INSTANCE.crack(state, world, pos, side, particleEngine, particles);
    }

    protected boolean crack(BlockState state, Level world, BlockPos pos, Direction side, Object particleEngine, BlockState particles) {
        return false;
    }

    public static boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, Object particleEngine, BlockState particles) {
        return particles == null || particles.isAir() || state != particles && INSTANCE.destroy(state, world, pos, particleEngine, particles);
    }

    protected boolean destroy(BlockState state, Level world, BlockPos pos, Object particleEngine, BlockState particles) {
        return false;
    }
}

