/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import shetiphian.core.client.gui.AbstractWidgetList;
import shetiphian.core.common.StringUtil;

public class WidgetInfoBox
extends AbstractWidgetList<WIBEntry> {
    private List<FormattedCharSequence> lines;
    private final Font font;

    public WidgetInfoBox(Minecraft mc, int x, int y, int width, int height) {
        super(mc, x, y, width, height, 10);
        this.font = mc.font;
        this.setFadeColors(0, 0);
        this.setScrollBarColors(Integer.MIN_VALUE, -2130706433, -1073741824);
    }

    public WidgetInfoBox addHeader(List<String> lines) {
        this.lines = this.resizeContent(lines);
        this.setRenderHeader(true, this.getHeaderHeight());
        return this;
    }

    private List<FormattedCharSequence> resizeContent(List<String> lines) {
        ArrayList<FormattedCharSequence> ret = new ArrayList<FormattedCharSequence>();
        for (String line : lines) {
            if (line == null) {
                ret.add(null);
                continue;
            }
            Component chat = StringUtil.newChatWithLinks(line, false);
            ret.addAll(ComponentRenderUtils.wrapComponents((FormattedText)chat, (int)(this.getRowWidth() - 8), (Font)this.font));
        }
        return ret;
    }

    private int getHeaderHeight() {
        int size = this.getBottom() - this.getY() - 8;
        int height = 0;
        if ((height += this.lines.size() * 10) < size) {
            height = size;
        }
        return height;
    }

    protected void renderHeader(GuiGraphics graphics, int relativeX, int relativeY) {
        int top = relativeY;
        for (FormattedCharSequence line : this.lines) {
            if (line != null && top > this.y0 - 10 && top < this.y1) {
                RenderSystem.enableBlend();
                graphics.drawString(this.font, line, this.x0 + 4, top, 0xFFFFFF);
                RenderSystem.disableBlend();
            }
            top += 10;
        }
    }

    @Override
    protected int getScrollbarPosition() {
        return this.x1 - 6;
    }

    @Override
    public int getRowWidth() {
        return this.width;
    }

    public void setInfo(WIBEntry info) {
        this.clearEntries();
        this.addEntry(info);
    }

    public void clear() {
        this.clearEntries();
    }

    @Override
    protected void renderBackground(GuiGraphics graphics, Tesselator tessellator) {
    }

    @Override
    protected void renderHoleBackground(GuiGraphics graphics, Tesselator tessellator, int y0, int y1) {
    }

    @Override
    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }

    public static class WIBEntry
    extends AbstractWidgetList.AWLEntry<WIBEntry> {
        public void render(GuiGraphics graphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
        }
    }
}

