/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.variable;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.client.book.template.variable.GenericArrayVariableSerializer;
import vazkii.patchouli.client.book.template.variable.ItemStackVariableSerializer;
import vazkii.patchouli.common.util.ItemStackUtil;

public class ItemStackArrayVariableSerializer
extends GenericArrayVariableSerializer<ItemStack> {
    public ItemStackArrayVariableSerializer() {
        super(new ItemStackVariableSerializer(), ItemStack.class);
    }

    @Override
    public ItemStack[] fromJson(JsonElement json, HolderLookup.Provider registries) {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (JsonElement e : array) {
                stacks.addAll(Arrays.asList(this.fromNonArray(e, registries)));
            }
            return stacks.toArray((ItemStack[])this.empty);
        }
        return this.fromNonArray(json, registries);
    }

    public ItemStack[] fromNonArray(JsonElement json, HolderLookup.Provider registries) {
        if (json.isJsonNull()) {
            return (ItemStack[])this.empty;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackUtil.loadStackListFromString(json.getAsString(), registries).toArray((ItemStack[])this.empty);
        }
        if (json.isJsonObject()) {
            return new ItemStack[]{ItemStackUtil.loadStackFromJson(json.getAsJsonObject(), registries)};
        }
        throw new IllegalArgumentException("Can't make an ItemStack from an array!");
    }
}

