/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.properties;

import com.google.common.base.Enums;
import com.satherov.crystalix.content.properties.ITranslatableValueProperty;
import com.satherov.crystalix.core.annotations.NothingNull;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

@NothingNull
public class EnumProperty<E extends Enum<E>>
implements ITranslatableValueProperty<E> {
    private final ItemStack stack;
    private final DataComponentType<E> componentType;
    private final String key;
    private final Class<E> enumClass;
    private final boolean enabled;
    private final E defaultValue;
    private E value;

    public EnumProperty(ItemStack stack, DataComponentType<E> componentType, String key, Class<E> enumClass, E defaultValue, boolean enabled) {
        this.stack = stack;
        this.componentType = componentType;
        this.key = key;
        this.enumClass = enumClass;
        this.enabled = enabled;
        this.defaultValue = defaultValue;
        this.value = (Enum)stack.getOrDefault(componentType, defaultValue);
    }

    public EnumProperty(ItemStack stack, DataComponentType<E> componentType, String key, Class<E> enumClass, E defaultValue) {
        this(stack, componentType, key, enumClass, defaultValue, true);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValueString() {
        return ((Enum)this.value).name().toLowerCase();
    }

    @Override
    public void setValueString(String val) {
        this.set((E)((Enum)Enums.getIfPresent(this.enumClass, (String)val.toUpperCase()).or(this.defaultValue)));
    }

    @Override
    public void set(E val) {
        if (!this.enabled) {
            return;
        }
        this.value = val;
        this.stack.set(this.componentType, val);
    }

    @Override
    public E get() {
        return this.value;
    }

    @Override
    public E next(boolean dir) {
        Enum[] enumValues = (Enum[])this.enumClass.getEnumConstants();
        int i = ((Enum)this.value).ordinal() + (dir ? 1 : -1);
        if (i < 0) {
            i += enumValues.length;
        }
        this.set((E)enumValues[i % enumValues.length]);
        return this.value;
    }
}

