/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.properties;

import com.satherov.crystalix.content.properties.ITranslatableProperty;
import com.satherov.crystalix.core.annotations.NothingNull;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import com.satherov.crystalix.core.lang.ILangEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

@NothingNull
public class BooleanProperty
implements ITranslatableProperty<Boolean> {
    private final ItemStack stack;
    private final DataComponentType<Boolean> componentType;
    private final String key;
    private final boolean enabled;
    private final ILangEntry langEntry;
    private boolean value;

    public BooleanProperty(ItemStack stack, DataComponentType<Boolean> componentType, String key, boolean defaultValue, boolean enabled, ILangEntry langEntry) {
        this.stack = stack;
        this.componentType = componentType;
        this.key = key;
        this.enabled = enabled;
        this.langEntry = langEntry;
        this.value = (Boolean)stack.getOrDefault(componentType, (Object)defaultValue);
    }

    public BooleanProperty(ItemStack stack, DataComponentType<Boolean> componentType, String key, boolean defaultValue, ILangEntry langEntry) {
        this(stack, componentType, key, defaultValue, true, langEntry);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValueString() {
        return this.value ? "enabled" : "disabled";
    }

    @Override
    public void setValueString(String val) {
        this.set(val.equals("enabled"));
    }

    @Override
    public void set(Boolean val) {
        if (!this.enabled) {
            return;
        }
        this.value = val;
        this.stack.set(this.componentType, (Object)val);
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    @Override
    public Boolean next(boolean dir) {
        this.set(!this.value);
        return this.value;
    }

    @Override
    public MutableComponent getTranslation() {
        return this.langEntry.translateFormatted(ChatFormatting.GRAY).append((Component)Component.literal((String)" ")).append((Component)(this.value ? CrystalixLanguage.PROPERTY_ENABLED.translateFormatted(ChatFormatting.DARK_GREEN) : CrystalixLanguage.PROPERTY_DISABLED.translateFormatted(ChatFormatting.DARK_RED)));
    }
}

