/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.properties;

import com.mojang.serialization.Codec;
import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.content.properties.BooleanProperty;
import com.satherov.crystalix.content.properties.EnumProperty;
import com.satherov.crystalix.content.properties.IEnumCodec;
import com.satherov.crystalix.content.properties.ITranslatableProperty;
import com.satherov.crystalix.core.annotations.NothingNull;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import com.satherov.crystalix.core.lang.ILangEntry;
import com.satherov.crystalix.core.lang.ITranslatable;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.jetbrains.annotations.Nullable;

@NothingNull
public class BlockProperties {
    public final ItemStack wand;
    public final BooleanProperty invisible;
    public final BooleanProperty shadeless;
    public final BooleanProperty reinforced;
    public final EnumProperty<Light> light;
    public final EnumProperty<Ghost> ghost;
    public final ITranslatableProperty<?>[] properties;

    public BlockProperties(ItemStack wand) {
        this.wand = wand;
        this.invisible = new BooleanProperty(wand, CrystalixRegistry.INVISIBLE.get(), "invisible", false, CrystalixLanguage.PROPERTY_INVISIBLE);
        this.shadeless = new BooleanProperty(wand, CrystalixRegistry.SHADELESS.get(), "shadeless", false, CrystalixLanguage.PROPERTY_SHADELESS);
        this.reinforced = new BooleanProperty(wand, CrystalixRegistry.REINFORCED.get(), "reinforced", false, CrystalixLanguage.PROPERTY_REINFORCED);
        this.light = new EnumProperty<Light>(wand, CrystalixRegistry.LIGHT.get(), "light", Light.class, Light.NONE);
        this.ghost = new EnumProperty<Ghost>(wand, CrystalixRegistry.GHOST.get(), "ghost", Ghost.class, Ghost.BLOCK_ALL);
        this.properties = new ITranslatableProperty[]{this.invisible, this.shadeless, this.reinforced, this.light, this.ghost};
    }

    @Nullable
    public ITranslatableProperty<?> get(String key) {
        for (ITranslatableProperty<?> option : this.properties) {
            if (!option.getKey().equals(key)) continue;
            return option;
        }
        return null;
    }

    public static enum Light implements StringRepresentable,
    ITranslatable
    {
        NONE(CrystalixLanguage.PROPERTY_LIGHT_NONE, ChatFormatting.GRAY),
        LIGHT(CrystalixLanguage.PROPERTY_LIGHT_LIGHT, ChatFormatting.GOLD),
        DARK(CrystalixLanguage.PROPERTY_LIGHT_DARK, ChatFormatting.DARK_GRAY),
        FAKE_LIGHT(CrystalixLanguage.PROPERTY_LIGHT_FAKE, ChatFormatting.LIGHT_PURPLE);

        public static final Codec<Light> CODEC;
        public static final StreamCodec<ByteBuf, Light> STREAM_CODEC;
        private final ILangEntry langEntry;
        private final ChatFormatting color;

        private Light(ILangEntry langEntry, ChatFormatting color) {
            this.langEntry = langEntry;
            this.color = color;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public MutableComponent getTranslation() {
            return CrystalixLanguage.PROPERTY_LIGHT.translateFormatted(ChatFormatting.GRAY).append((Component)Component.literal((String)" ")).append((Component)this.langEntry.translateFormatted(this.color));
        }

        static {
            CODEC = IEnumCodec.makeCodec(Light.class);
            STREAM_CODEC = IEnumCodec.makeStreamCodec(Light.class);
        }
    }

    public static enum Ghost implements StringRepresentable,
    ITranslatable
    {
        BLOCK_ALL(CrystalixLanguage.PROPERTY_GHOST_ALL, ChatFormatting.DARK_GRAY, false, context -> false),
        ALLOW_ALL(CrystalixLanguage.PROPERTY_GHOST_ALL, ChatFormatting.DARK_GRAY, true, context -> true),
        BLOCK_PLAYER(CrystalixLanguage.PROPERTY_GHOST_PLAYER, ChatFormatting.AQUA, false, context -> !(context.getEntity() instanceof Player)),
        ALLOW_PLAYER(CrystalixLanguage.PROPERTY_GHOST_PLAYER, ChatFormatting.AQUA, true, context -> context.getEntity() instanceof Player),
        BLOCK_MONSTER(CrystalixLanguage.PROPERTY_GHOST_MONSTER, ChatFormatting.RED, false, context -> !(context.getEntity() instanceof Monster)),
        ALLOW_MONSTER(CrystalixLanguage.PROPERTY_GHOST_MONSTER, ChatFormatting.RED, true, context -> context.getEntity() instanceof Monster),
        BLOCK_ANIMAL(CrystalixLanguage.PROPERTY_GHOST_ANIMAL, ChatFormatting.GREEN, false, context -> !(context.getEntity() instanceof Animal)),
        ALLOW_ANIMAL(CrystalixLanguage.PROPERTY_GHOST_ANIMAL, ChatFormatting.GREEN, true, context -> context.getEntity() instanceof Animal);

        public static final Codec<Ghost> CODEC;
        public static final StreamCodec<ByteBuf, Ghost> STREAM_CODEC;
        private final ILangEntry langEntry;
        private final ChatFormatting color;
        private final boolean state;
        private final Predicate<EntityCollisionContext> collisionPredicate;

        private Ghost(ILangEntry langEntry, ChatFormatting color, boolean state, Predicate<EntityCollisionContext> collisionPredicate) {
            this.langEntry = langEntry;
            this.color = color;
            this.state = state;
            this.collisionPredicate = collisionPredicate;
        }

        public boolean canCollide(EntityCollisionContext context) {
            return this.collisionPredicate.test(context);
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public MutableComponent getTranslation() {
            return CrystalixLanguage.PROPERTY_GHOST.translateFormatted(ChatFormatting.GRAY).append((Component)Component.literal((String)" ")).append((Component)(this.state ? CrystalixLanguage.PROPERTY_GHOST_ALLOW.translateFormatted(ChatFormatting.DARK_GREEN) : CrystalixLanguage.PROPERTY_GHOST_DENY.translateFormatted(ChatFormatting.DARK_RED))).append((Component)Component.literal((String)" ")).append((Component)this.langEntry.translateFormatted(this.color));
        }

        static {
            CODEC = IEnumCodec.makeCodec(Ghost.class);
            STREAM_CODEC = IEnumCodec.makeStreamCodec(Ghost.class);
        }
    }
}

