/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.item;

import com.satherov.crystalix.CrystalixConfig;
import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.content.properties.ITranslatableProperty;
import com.satherov.crystalix.core.annotations.NothingNull;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@NothingNull
public class CrystalixWand
extends Item {
    public CrystalixWand(Item.Properties properties) {
        super(properties.stacksTo(1).component(CrystalixRegistry.INVISIBLE, (Object)false).component(CrystalixRegistry.SHADELESS, (Object)false).component(CrystalixRegistry.REINFORCED, (Object)false).component(CrystalixRegistry.LIGHT, (Object)BlockProperties.Light.NONE).component(CrystalixRegistry.GHOST, (Object)BlockProperties.Ghost.BLOCK_ALL));
    }

    public static void sendMessage(Player player, ITranslatableProperty<?> property) {
        player.displayClientMessage((Component)property.getTranslation(), true);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)CrystalixLanguage.TOOLTIP_BULK.translateFormatted(ChatFormatting.GRAY));
        Arrays.stream(new BlockProperties((ItemStack)stack).properties).toList().forEach(property -> tooltipComponents.add((Component)property.getTranslation()));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player != null && !level.isClientSide && !this.applyToBlock((LevelAccessor)level, blockpos = context.getClickedPos(), player)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean applyToBlock(LevelAccessor accessor, BlockPos pos, Player player) {
        if (!(accessor.getBlockState(pos).getBlock() instanceof CrystalixGlass)) {
            return false;
        }
        ItemStack wand = player.getMainHandItem();
        Set<BlockPos> blocksToModify = player.isCrouching() ? this.getConnectedBlocks(accessor, pos, accessor.getBlockState(pos).getBlock()) : Set.of(pos);
        for (BlockPos targetPos : blocksToModify) {
            BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)accessor.getBlockState(targetPos).setValue((Property)CrystalixGlass.INVISIBLE, (Comparable)Objects.requireNonNull((Boolean)wand.get(CrystalixRegistry.INVISIBLE)))).setValue((Property)CrystalixGlass.SHADELESS, (Comparable)Objects.requireNonNull((Boolean)wand.get(CrystalixRegistry.SHADELESS)))).setValue((Property)CrystalixGlass.REINFORCED, (Comparable)Objects.requireNonNull((Boolean)wand.get(CrystalixRegistry.REINFORCED)))).setValue(CrystalixGlass.LIGHT, (Comparable)((Object)Objects.requireNonNull((BlockProperties.Light)wand.get(CrystalixRegistry.LIGHT))))).setValue(CrystalixGlass.GHOST, (Comparable)((Object)Objects.requireNonNull((BlockProperties.Ghost)wand.get(CrystalixRegistry.GHOST))));
            accessor.setBlock(targetPos, newState, 3);
        }
        return true;
    }

    public Set<BlockPos> getConnectedBlocks(LevelAccessor accessor, BlockPos start, Block targetBlock) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty() && visited.size() < CrystalixConfig.getMaxWandEdit()) {
            BlockPos pos = (BlockPos)queue.poll();
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.relative(direction);
                if (visited.contains(neighborPos) || !accessor.getBlockState(neighborPos).is(targetBlock)) continue;
                queue.add(neighborPos);
                visited.add(neighborPos);
            }
        }
        return visited;
    }
}

