/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content;

import com.mojang.serialization.Codec;
import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.item.CrystalixWand;
import com.satherov.crystalix.content.properties.BlockProperties;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CrystalixRegistry {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"crystalix");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"crystalix");
    public static final TagKey<Item> ITEM_TAG = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"blocks"));
    public static final TagKey<Block> BLOCK_TAG = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"blocks"));
    public static final Map<BlockTypes, TagKey<Block>> BLOCK_TAGS = Arrays.stream(BlockTypes.values()).collect(Collectors.toMap(Function.identity(), type -> BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)type.getSerializedName())), (a, b) -> b, () -> new EnumMap(BlockTypes.class)));
    public static final Map<BlockTypes, TagKey<Item>> ITEM_TAGS = Arrays.stream(BlockTypes.values()).collect(Collectors.toMap(Function.identity(), type -> ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)type.getSerializedName())), (a, b) -> b, () -> new EnumMap(BlockTypes.class)));
    public static final Supplier<DataComponentType<Boolean>> INVISIBLE = DATA_COMPONENT_TYPES.register("invisible", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> SHADELESS = DATA_COMPONENT_TYPES.register("shadeless", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<Boolean>> REINFORCED = DATA_COMPONENT_TYPES.register("reinforced", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final Supplier<DataComponentType<BlockProperties.Ghost>> GHOST = DATA_COMPONENT_TYPES.register("ghost", () -> DataComponentType.builder().persistent(BlockProperties.Ghost.CODEC).networkSynchronized(BlockProperties.Ghost.STREAM_CODEC).build());
    public static final Supplier<DataComponentType<BlockProperties.Light>> LIGHT = DATA_COMPONENT_TYPES.register("light", () -> DataComponentType.builder().persistent(BlockProperties.Light.CODEC).networkSynchronized(BlockProperties.Light.STREAM_CODEC).build());
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"crystalix");
    public static DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"crystalix");
    public static final DeferredHolder<Item, CrystalixWand> WAND = ITEMS.register("crystalix_wand", () -> new CrystalixWand(new Item.Properties()));
    public static final Map<DyeColor, Map<BlockTypes, DeferredHolder<Block, CrystalixGlass>>> BLOCKS_MAP = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), color -> Arrays.stream(BlockTypes.values()).collect(Collectors.toMap(Function.identity(), type -> {
        String name = type == BlockTypes.GLASS ? String.format("%s_crystalix_glass", color.getName()) : String.format("%s_%s_crystalix_glass", color.getName(), type.getSerializedName());
        return CrystalixRegistry.register(name, () -> new CrystalixGlass((DyeColor)color));
    }, (a, b) -> b, () -> new EnumMap(BlockTypes.class))), (a, b) -> b, () -> new EnumMap(DyeColor.class)));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("creative_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)String.format("itemGroup.%s", "crystalix"))).icon(() -> ((CrystalixGlass)((Object)((Object)((Object)BLOCKS_MAP.get(DyeColor.WHITE).get((Object)BlockTypes.GLASS).get())))).asItem().getDefaultInstance()).displayItems((parameters, output) -> ITEMS.getEntries().stream().map(Supplier::get).map(Item::getDefaultInstance).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());

    private static DeferredHolder<Block, CrystalixGlass> register(String name, Supplier<CrystalixGlass> properties) {
        DeferredHolder block = BLOCKS.register(name, properties);
        ITEMS.registerSimpleBlockItem(name, (Supplier)block);
        return block;
    }

    public static enum BlockTypes implements StringRepresentable
    {
        GLASS((TagKey<Item>)Tags.Items.GEMS_AMETHYST),
        CLEAR((TagKey<Item>)Tags.Items.GEMS_QUARTZ),
        BORDERED((TagKey<Item>)Tags.Items.INGOTS_IRON);

        private final TagKey<Item> tag;

        private BlockTypes(TagKey<Item> tag) {
            this.tag = tag;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

