/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.compat.jade;

import com.satherov.crystalix.CrystalixConfig;
import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.item.CrystalixWand;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.core.annotations.NothingNull;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import com.satherov.crystalix.core.lang.ILangEntry;
import com.satherov.crystalix.core.lang.ITranslatable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
@NothingNull
public class CrystalixJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation CRYSTALIX_BLOCK = ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"crystalix_block");

    private static Component getTranslation(ILangEntry langEntry, boolean state) {
        return langEntry.translateFormatted(ChatFormatting.GRAY).append((Component)Component.literal((String)" ")).append((Component)(state ? CrystalixLanguage.PROPERTY_ENABLED.translateFormatted(ChatFormatting.DARK_GREEN) : CrystalixLanguage.PROPERTY_DISABLED.translateFormatted(ChatFormatting.DARK_RED)));
    }

    private static <T extends ITranslatable> Component getTranslation(T state) {
        return state.getTranslation();
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)CrystalixComponentProvider.INSTANCE, CrystalixGlass.class);
    }

    private static void showTooltips(ITooltip tooltip, BlockAccessor accessor) {
        tooltip.add(CrystalixJadePlugin.getTranslation(CrystalixLanguage.PROPERTY_INVISIBLE, (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.INVISIBLE)));
        tooltip.add(CrystalixJadePlugin.getTranslation(CrystalixLanguage.PROPERTY_SHADELESS, (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.SHADELESS)));
        tooltip.add(CrystalixJadePlugin.getTranslation(CrystalixLanguage.PROPERTY_REINFORCED, (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.REINFORCED)));
        tooltip.add(CrystalixJadePlugin.getTranslation((BlockProperties.Light)((Object)accessor.getBlockState().getValue(CrystalixGlass.LIGHT))));
        tooltip.add(CrystalixJadePlugin.getTranslation((BlockProperties.Ghost)((Object)accessor.getBlockState().getValue(CrystalixGlass.GHOST))));
    }

    static enum CrystalixComponentProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            switch (CrystalixConfig.getJadeMode()) {
                case ALWAYS: {
                    CrystalixJadePlugin.showTooltips(tooltip, accessor);
                    break;
                }
                case WAND: {
                    if (!(accessor.getPlayer().getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof CrystalixWand) && !(accessor.getPlayer().getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof CrystalixWand)) break;
                    CrystalixJadePlugin.showTooltips(tooltip, accessor);
                    break;
                }
            }
        }

        public ResourceLocation getUid() {
            return CRYSTALIX_BLOCK;
        }
    }
}

