/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.client;

import com.satherov.crystalix.content.CrystalixUtil;
import com.satherov.crystalix.content.item.CrystalixWand;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import com.satherov.crystalix.core.lang.ILangEntry;
import com.satherov.crystalix.network.CrystalixNetworking;
import com.satherov.crystalix.network.CyclePropertyPayload;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;

public class KeybindManager {
    public static final KeyMapping CYCLE_INVISIBLE = KeybindManager.register(CrystalixLanguage.KEY_INVISIBLE, 66);
    public static final KeyMapping CYCLE_SHADELESS = KeybindManager.register(CrystalixLanguage.KEY_SHADELESS, 90);
    public static final KeyMapping CYCLE_REINFORCED = KeybindManager.register(CrystalixLanguage.KEY_REINFORCED, 88);
    public static final KeyMapping CYCLE_LIGHT = KeybindManager.register(CrystalixLanguage.KEY_LIGHT, 67);
    public static final KeyMapping CYCLE_GHOST = KeybindManager.register(CrystalixLanguage.KEY_GHOST, 86);

    private static KeyMapping register(ILangEntry entry, int key) {
        return new KeyMapping(entry.getTranslationKey(), key, CrystalixLanguage.KEY_CATEGORY.getTranslationKey());
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.Key event) {
        BlockProperties properties;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack wand = CrystalixUtil.getWand((Player)player);
        if (wand.isEmpty() || !(wand.getItem() instanceof CrystalixWand)) {
            return;
        }
        if (CYCLE_INVISIBLE.consumeClick()) {
            properties = new BlockProperties(wand);
            properties.invisible.next();
            CrystalixNetworking.sendToServer(new CyclePropertyPayload(properties.invisible));
        }
        if (CYCLE_SHADELESS.consumeClick()) {
            properties = new BlockProperties(wand);
            properties.shadeless.next();
            CrystalixNetworking.sendToServer(new CyclePropertyPayload(properties.shadeless));
        }
        if (CYCLE_REINFORCED.consumeClick()) {
            properties = new BlockProperties(wand);
            properties.reinforced.next();
            CrystalixNetworking.sendToServer(new CyclePropertyPayload(properties.reinforced));
        }
        if (CYCLE_LIGHT.consumeClick()) {
            properties = new BlockProperties(wand);
            properties.light.next();
            CrystalixNetworking.sendToServer(new CyclePropertyPayload(properties.light));
        }
        if (CYCLE_GHOST.consumeClick()) {
            properties = new BlockProperties(wand);
            properties.ghost.next();
            CrystalixNetworking.sendToServer(new CyclePropertyPayload(properties.ghost));
        }
    }
}

