/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public static Codec<WoodType> CODEC;
    public static StreamCodec<ByteBuf, WoodType> STREAM_CODEC;
    public static Supplier<EntityDataSerializer<WoodType>> ENTITY_SERIALIZER;
    public final Block planks;
    public final Block log;
    private final Supplier<net.minecraft.world.level.block.state.properties.WoodType> vanillaType = Suppliers.memoize(this::detectVanillaWood);
    private final Supplier<Boat.Type> boatType = Suppliers.memoize(this::detectVanillaBoat);

    @Nullable
    private Boat.Type detectVanillaBoat() {
        if (this == VanillaWoodTypes.OAK) {
            return Boat.Type.OAK;
        }
        ResourceLocation id = this.getId();
        Set<String> conventions = Set.of(id.getPath(), id.getNamespace() + id.getPath(), id.getNamespace() + "_" + id.getPath(), id.getNamespace() + "/" + id.getPath(), id.toString());
        for (String s : conventions) {
            Boat.Type o = Boat.Type.byName((String)s);
            if (o == Boat.Type.OAK) continue;
            return o;
        }
        return null;
    }

    @Nullable
    private net.minecraft.world.level.block.state.properties.WoodType detectVanillaWood() {
        Object object = this.getChild("hanging_sign");
        if (object instanceof CeilingHangingSignBlock) {
            CeilingHangingSignBlock c = (CeilingHangingSignBlock)object;
            return c.type();
        }
        object = this.getChild("sign");
        if (object instanceof SignBlock) {
            SignBlock f = (SignBlock)object;
            return f.type();
        }
        String i = this.id.getNamespace().equals("minecraft") ? this.id.getPath() : this.id.toString();
        Stream values = net.minecraft.world.level.block.state.properties.WoodType.values();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = values.filter(v -> v.name().equals(i)).findAny();
        return o.orElse(null);
    }

    public WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
    }

    @Override
    public ItemLike mainChild() {
        return this.planks;
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType.get();
    }

    @Nullable
    public Boat.Type toVanillaBoat() {
        return this.boatType.get();
    }

    @NotNull
    public net.minecraft.world.level.block.state.properties.WoodType toVanillaOrOak() {
        net.minecraft.world.level.block.state.properties.WoodType v = this.toVanilla();
        if (v != null) {
            return v;
        }
        return net.minecraft.world.level.block.state.properties.WoodType.OAK;
    }

    @NotNull
    public Boat.Type toVanillaBoatOrOak() {
        Boat.Type v = this.toVanillaBoat();
        if (v != null) {
            return v;
        }
        return Boat.Type.OAK;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.planks.defaultBlockState().ignitedByLava();
    }

    public MapColor getColor() {
        return this.planks.defaultMapColor();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", BuiltInRegistries.BLOCK));
        this.addChild("wood", this.findLogRelatedBlock("", "wood", "hyphae", "bark"));
        this.addChild("stripped_log", this.findStrippedLog("log", "stem", "stalk"));
        this.addChild("stripped_wood", this.findStrippedLog("wood", "hyphae", "bark"));
        this.addChild("slab", this.findRelatedEntry("slab", BuiltInRegistries.BLOCK));
        this.addChild("stairs", this.findRelatedEntry("stairs", BuiltInRegistries.BLOCK));
        Block fence = (Block)this.findRelatedEntry("fence", BuiltInRegistries.BLOCK);
        this.addChild("fence", fence);
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", BuiltInRegistries.BLOCK));
        this.addChild("door", this.findRelatedEntry("door", BuiltInRegistries.BLOCK));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", BuiltInRegistries.BLOCK));
        this.addChild("button", this.findRelatedEntry("button", BuiltInRegistries.BLOCK));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", BuiltInRegistries.BLOCK));
        this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign", BuiltInRegistries.BLOCK));
        this.addChild("wall_hanging_sign", this.findRelatedEntry("wall_hanging_sign", BuiltInRegistries.BLOCK));
        this.addChild("sign", this.findRelatedEntry("sign", BuiltInRegistries.BLOCK));
        this.addChild("wall_sign", this.findRelatedEntry("wall_sign", BuiltInRegistries.BLOCK));
        if (this.id.getNamespace().matches("tfc|afc")) {
            this.addChild("sign", this.findRelatedEntry("sign", "", (Registry)BuiltInRegistries.BLOCK));
            this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign/wrought_sign", "", (Registry)BuiltInRegistries.BLOCK));
        }
        if (fence != null && CompatHandler.DIAGONALFENCES) {
            Optional diagonalFence = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.fromNamespaceAndPath((String)"diagonalfences", (String)Utils.getID(fence).toString().replace(":", "/")));
            diagonalFence.ifPresent(block -> this.addChild("diagonalfences:fence", block));
        }
    }

    @Override
    public void initializeChildrenItems() {
        if (this.id.toString().equals("minecraft:bamboo")) {
            this.addChild("boat", this.findRelatedEntry("raft", BuiltInRegistries.ITEM));
            this.addChild("chest_boat", this.findRelatedEntry("chest_raft", BuiltInRegistries.ITEM));
        } else {
            this.addChild("boat", this.findRelatedItem("boat", "raft"));
            this.addChild("chest_boat", this.findRelatedItem("chest_boat", "chest_raft"));
        }
        this.addChild("sapling", this.findRelatedEntry("sapling", BuiltInRegistries.ITEM));
        if (this.id.getNamespace().matches("tfc|afc")) {
            this.addChild("stick", this.findRelatedEntry("twig", BuiltInRegistries.BLOCK));
            this.addChild("boat", this.findRelatedEntry("boat", "", (Registry)BuiltInRegistries.BLOCK));
        }
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefix, String suffix, Registry<V> reg) {
        if (!((String)suffix).isEmpty()) {
            suffix = "_" + (String)suffix;
        }
        ResourceLocation[] targets = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)this.id.getNamespace(), (String)(this.id.getPath() + "_" + prefix + (String)suffix)), ResourceLocation.fromNamespaceAndPath((String)this.id.getNamespace(), (String)(prefix + "_" + this.id.getPath() + (String)suffix)), this.id.withPath(this.id.getPath() + "_planks_" + prefix + (String)suffix), this.id.withPath("wood/planks/" + this.id.getPath() + "_" + prefix), this.id.withPath("wood/" + prefix + (String)suffix + "/" + this.id.getPath())};
        return Utils.findFirstInRegistry(reg, targets);
    }

    @Nullable
    protected Block findStrippedLog(String ... possibleNames) {
        for (String v : possibleNames) {
            Block stripped;
            Block b = this.getBlockOfThis(v);
            if (v == null || (stripped = (Block)AxeItem.STRIPPABLES.get(b)) == null || stripped == b) continue;
            return stripped;
        }
        return this.findLogRelatedBlock("stripped", possibleNames);
    }

    @Nullable
    protected Item findRelatedItem(String ... names) {
        for (String n : names) {
            Item b = (Item)this.findRelatedEntry(n, BuiltInRegistries.ITEM);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected Block findLogRelatedBlock(String prefix, String ... possibleSuffix) {
        for (String n : possibleSuffix) {
            Block b = this.findLogWithPrefix(prefix, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected Block findLogWithPrefix(String prefix, String suffix) {
        if (this.id.getNamespace().matches("tfc|afc")) {
            Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
            Optional o = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.fromNamespaceAndPath((String)this.getNamespace(), (String)("wood/" + (String)prefix_ + suffix + "/" + this.id.getPath())));
            if (o.isPresent()) {
                return (Block)o.get();
            }
        }
        List<ResourceLocation> targets = WoodType.makeKnownIDConventionsPrefix(this.id.getNamespace(), this.id.getPath(), prefix, suffix, Utils.getID(this.log).getPath());
        return (Block)Utils.findFirstInRegistry(BuiltInRegistries.BLOCK, targets);
    }

    @NotNull
    private static List<ResourceLocation> makeKnownIDConventionsPrefix(String myNamespace, String myPath, String prefix, String suffix, String alternateNamespace) {
        boolean noneEmpty = !prefix.isEmpty() && !suffix.isEmpty();
        Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
        ArrayList<ResourceLocation> targets = new ArrayList<ResourceLocation>();
        targets.add(ResourceLocation.fromNamespaceAndPath((String)myNamespace, (String)(myPath + "_" + (String)prefix_ + suffix)));
        targets.add(ResourceLocation.fromNamespaceAndPath((String)myNamespace, (String)(alternateNamespace + "_" + (String)prefix_ + suffix)));
        if (!noneEmpty) {
            targets.add(ResourceLocation.fromNamespaceAndPath((String)myNamespace, (String)((String)prefix_ + myPath + "_" + suffix)));
            targets.add(ResourceLocation.fromNamespaceAndPath((String)myNamespace, (String)((String)prefix_ + alternateNamespace + "_" + suffix)));
        }
        if (myPath.endsWith(suffix)) {
            targets.add(ResourceLocation.fromNamespaceAndPath((String)myNamespace, (String)((String)prefix_ + myPath)));
        }
        return targets;
    }

    static List<ResourceLocation> makeKnownIDConventions(ResourceLocation id, String ... suffixKeyword) {
        String myPath = id.getPath();
        String myNamespace = id.getNamespace();
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        for (String suffix : suffixKeyword) {
            resources.addAll(WoodType.makeKnownIDConventionsPrefix(myNamespace, myPath, "", suffix, myPath));
        }
        return resources;
    }

    @Nullable
    static Block findLog(ResourceLocation id) {
        List<ResourceLocation> tests = WoodType.makeKnownIDConventions(id, "log", "stem", "stalk", "hyphae");
        return (Block)Utils.findFirstInRegistry(BuiltInRegistries.BLOCK, tests);
    }

    @Nullable
    static Block findPlanks(ResourceLocation id) {
        List<ResourceLocation> tests = WoodType.makeKnownIDConventions(id, "planks", "plank");
        return (Block)Utils.findFirstInRegistry(BuiltInRegistries.BLOCK, tests);
    }

    public BlockBehaviour.Properties copyProperties() {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.of();
        p.mapColor(this.getColor());
        if (this.canBurn()) {
            p.ignitedByLava();
        }
        p.sound(this.getSound());
        return p;
    }

    static {
        WoodTypeRegistry.touch();
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<WoodType> {
        private Supplier<Block> planksFinder;
        private Supplier<Block> logFinder;

        public Finder(ResourceLocation id) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.log(() -> WoodType.findLog(id));
            this.planks(() -> WoodType.findPlanks(id));
        }

        public Finder planks(Supplier<Block> planksFinder) {
            this.planksFinder = planksFinder;
            return this;
        }

        public Finder planks(ResourceLocation id) {
            return this.planks(() -> (Block)BuiltInRegistries.BLOCK.getOptional(id).orElseThrow(() -> new IllegalStateException("Failed to find planks block: " + String.valueOf(id))));
        }

        public Finder planks(String planksName) {
            return this.planks(Utils.idWithOptionalNamespace(planksName, this.id.getNamespace()));
        }

        public Finder planksAffix(String prefix, String suffix) {
            return this.planks(prefix + this.id.getPath() + suffix);
        }

        public Finder planksSuffix(String suffix) {
            return this.planks(this.id.getPath() + suffix);
        }

        public Finder log(Supplier<Block> logFinder) {
            this.logFinder = logFinder;
            return this;
        }

        public Finder log(ResourceLocation id) {
            return this.log(() -> (Block)BuiltInRegistries.BLOCK.getOptional(id).orElseThrow(() -> new IllegalStateException("Failed to find log block: " + String.valueOf(id))));
        }

        public Finder log(String nameLog) {
            return this.log(Utils.idWithOptionalNamespace(nameLog, this.id.getNamespace()));
        }

        public Finder logAffix(String prefix, String suffix) {
            return this.log(prefix + this.id.getPath() + suffix);
        }

        public Finder logSuffix(String suffix) {
            return this.log(this.id.getPath() + suffix);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatHelper.isModLoaded(this.id.getNamespace())) {
                try {
                    Block plank = (Block)Preconditions.checkNotNull((Object)this.planksFinder.get(), (String)"Manual Finder - failed to find a plank block for {}", (Object)this.id);
                    Block log = (Block)Preconditions.checkNotNull((Object)this.logFinder.get(), (String)"Manual Finder - failed to find a log block for {}", (Object)this.id);
                    WoodType woodType = new WoodType(this.id, plank, log);
                    this.childNames.forEach((key, value) -> {
                        try {
                            ItemLike obj = (ItemLike)Preconditions.checkNotNull((Object)((ItemLike)value.get()));
                            woodType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for WoodType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(woodType);
                }
                catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom WoodType:  {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }

        @Deprecated(forRemoval=true)
        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.planksFinder = planks;
            this.logFinder = log;
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(ResourceLocation.fromNamespaceAndPath((String)modId, (String)woodTypeName), ResourceLocation.fromNamespaceAndPath((String)modId, (String)planksName), ResourceLocation.fromNamespaceAndPath((String)modId, (String)logName));
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)BuiltInRegistries.BLOCK.get(planksName), () -> (Block)BuiltInRegistries.BLOCK.get(logName));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, String childName) {
            this.childBlock(childType, childName);
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, ResourceLocation childName) {
            this.childBlock(childType, childName);
        }
    }
}

