/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public abstract class MimicBlock
extends Block {
    protected MimicBlock(BlockBehaviour.Properties properties) {
        super(properties.emissiveRendering(MimicBlock::hasEmissiveRendering));
    }

    private static boolean hasEmissiveRendering(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        BlockEntity blockEntity = blockGetter.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.emissiveRendering(blockGetter, pos);
        }
        return false;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).isAir() && !(mimicState.getBlock() instanceof MimicBlock)) {
            return Math.min(super.getDestroyProgress(state, player, worldIn, pos), mimicState.getDestroyProgress(player, worldIn, pos));
        }
        return super.getDestroyProgress(state, player, worldIn, pos);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)object;
            BlockState heldState = tile.getHeldBlock();
            Object object2 = builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (!ForgeHelper.canHarvestBlock(heldState, builder.getLevel(), BlockPos.containing((Position)((Position)builder.getParameter(LootContextParams.ORIGIN))), player)) {
                    return drops;
                }
            }
            List newDrops = heldState.getDrops(builder);
            drops.addAll(newDrops);
        }
        return drops;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }
}

