/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.world.feature;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.blocks.flammable.ForceLeavesBlock;
import com.mrbysco.forcecraft.blocks.flammable.ForceLogBlock;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.world.feature.ForceFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ForceFeatureKeys {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FORCE = ForceFeatureKeys.createConfiguredKey("ore_force");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FORCE_BURIED = ForceFeatureKeys.createConfiguredKey("ore_force_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FORCE_TREE = ForceFeatureKeys.createConfiguredKey("force_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG = ForceFeatureKeys.createConfiguredKey("force_tree_with_bees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_FORCE = ForceFeatureKeys.createConfiguredKey("trees_force");
    public static final ResourceKey<PlacedFeature> PLACED_ORE_FORCE = ForceFeatureKeys.createPlacedKey("ore_force");
    public static final ResourceKey<PlacedFeature> PLACED_ORE_FORCE_BURIED = ForceFeatureKeys.createPlacedKey("ore_force_buried");
    public static final ResourceKey<PlacedFeature> PLACED_FORCE_TREE = ForceFeatureKeys.createPlacedKey("force_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FORCE_TREE_BEES_002 = ForceFeatureKeys.createPlacedKey("force_tree_bees_002");

    public static ResourceKey<ConfiguredFeature<?, ?>> createConfiguredKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Reference.modLoc(name));
    }

    public static ResourceKey<PlacedFeature> createPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Reference.modLoc(name));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(BlockState trunkState, BlockState foliageState, int baseHeight, int heightRandA, int heightRandB, int p_195152_) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)trunkState), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.simple((BlockState)foliageState), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)p_195152_), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createForceTree() {
        return ForceFeatureKeys.createStraightBlobTree(((ForceLogBlock)((Object)ForceRegistry.FORCE_LOG.get())).defaultBlockState(), ((ForceLeavesBlock)((Object)ForceRegistry.FORCE_LEAVES.get())).defaultBlockState(), 4, 2, 0, 2).ignoreVines();
    }

    public static void configuredBootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneRuleTest = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateRuleTest = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> list = List.of(OreConfiguration.target((RuleTest)stoneRuleTest, (BlockState)((DropExperienceBlock)ForceRegistry.POWER_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateRuleTest, (BlockState)((DropExperienceBlock)ForceRegistry.DEEPSLATE_POWER_ORE.get()).defaultBlockState()));
        HolderGetter placedFeatureHolderGetter = context.lookup(Registries.PLACED_FEATURE);
        Holder.Reference PLACED_FORCE_TREE_BEES = placedFeatureHolderGetter.getOrThrow(PLACED_FORCE_TREE_BEES_002);
        Holder.Reference PLACED_FORCE_TREE = placedFeatureHolderGetter.getOrThrow(ForceFeatureKeys.PLACED_FORCE_TREE);
        FeatureUtils.register(context, ORE_FORCE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(list, 6));
        FeatureUtils.register(context, ORE_FORCE_BURIED, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(list, 6, 1.0f));
        BeehiveDecorator decorator_005 = new BeehiveDecorator(0.05f);
        FeatureUtils.register(context, FORCE_TREE, ForceFeatures.FORCE_TREE.get(), (FeatureConfiguration)ForceFeatureKeys.createForceTree().build());
        FeatureUtils.register(context, FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG, ForceFeatures.FORCE_TREE.get(), (FeatureConfiguration)ForceFeatureKeys.createForceTree().decorators(List.of(decorator_005)).build());
        FeatureUtils.register(context, TREES_FORCE, (Feature)Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)PLACED_FORCE_TREE_BEES, 0.2f)), (Holder)PLACED_FORCE_TREE));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier1, PlacementModifier modifier2) {
        return List.of(modifier1, InSquarePlacement.spread(), modifier2, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return ForceFeatureKeys.orePlacement((PlacementModifier)CountPlacement.of((int)count), modifier);
    }

    public static void placedBootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, PLACED_ORE_FORCE, (Holder)holdergetter.getOrThrow(ORE_FORCE), ForceFeatureKeys.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)48))));
        PlacementUtils.register(context, PLACED_ORE_FORCE_BURIED, (Holder)holdergetter.getOrThrow(ORE_FORCE_BURIED), ForceFeatureKeys.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        PlacementUtils.register(context, PLACED_FORCE_TREE, (Holder)holdergetter.getOrThrow(FORCE_TREE), (List)VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)3), (Block)((Block)ForceRegistry.FORCE_SAPLING.get())));
        PlacementUtils.register(context, PLACED_FORCE_TREE_BEES_002, (Holder)holdergetter.getOrThrow(FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG), (List)VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)3), (Block)((Block)ForceRegistry.FORCE_SAPLING.get())));
    }
}

