/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.registry;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ForceFluids {
    private static final ResourceLocation STILL_METAL = Reference.modLoc("block/force_fluid_source");
    private static final ResourceLocation FLOWING_METAL = Reference.modLoc("block/force_fluid_flowing");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"forcecraft");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"forcecraft");
    private static Supplier<FluidType> FORCE_TYPE = FLUID_TYPES.register("force", () -> new FluidType(ForceFluids.createTypeProperties()){

        public double motionScale(Entity entity) {
            return entity.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        }

        public void setItemMovement(ItemEntity entity) {
            Vec3 vec3 = entity.getDeltaMovement();
            entity.setDeltaMovement(vec3.x * (double)0.95f, vec3.y + (double)(vec3.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3.z * (double)0.95f);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(this){

                public ResourceLocation getStillTexture() {
                    return STILL_METAL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOWING_METAL;
                }

                public int getTintColor() {
                    return -1;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    int color = this.getTintColor();
                    return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                }
            });
        }
    });
    public static Supplier<FlowingFluid> FORCE_FLUID_SOURCE;
    public static Supplier<FlowingFluid> FORCE_FLUID_FLOWING;
    public static BaseFlowingFluid.Properties FLUID_FORCE_PROPERTIES;

    public static void registerFluids() {
        FORCE_FLUID_SOURCE = FLUIDS.register("fluid_force_source", () -> new BaseFlowingFluid.Source(FLUID_FORCE_PROPERTIES));
        FORCE_FLUID_FLOWING = FLUIDS.register("fluid_force_flowing", () -> new BaseFlowingFluid.Flowing(FLUID_FORCE_PROPERTIES));
    }

    public static FluidType.Properties createTypeProperties() {
        return FluidType.Properties.create().canSwim(false).canDrown(false).pathType(PathType.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).rarity(Rarity.COMMON).lightLevel(0).density(2000).viscosity(1000).temperature(120);
    }

    static {
        FLUID_FORCE_PROPERTIES = new BaseFlowingFluid.Properties(() -> FORCE_TYPE.get(), () -> (Fluid)FORCE_FLUID_SOURCE.get(), () -> (Fluid)FORCE_FLUID_FLOWING.get()).bucket(ForceRegistry.BUCKET_FLUID_FORCE).block(() -> (LiquidBlock)ForceRegistry.FORCE_FLUID_BLOCK.get());
    }
}

