/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.registry;

import com.mrbysco.forcecraft.entities.AngryEndermanEntity;
import com.mrbysco.forcecraft.entities.ChuChuEntity;
import com.mrbysco.forcecraft.entities.ColdChickenEntity;
import com.mrbysco.forcecraft.entities.ColdCowEntity;
import com.mrbysco.forcecraft.entities.ColdPigEntity;
import com.mrbysco.forcecraft.entities.CreeperTotEntity;
import com.mrbysco.forcecraft.entities.EnderTotEntity;
import com.mrbysco.forcecraft.entities.FairyEntity;
import com.mrbysco.forcecraft.entities.projectile.FlaskEntity;
import com.mrbysco.forcecraft.entities.projectile.ForceArrowEntity;
import com.mrbysco.forcecraft.items.nonburnable.NonBurnableItemEntity;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ForceEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"forcecraft");
    public static final Supplier<EntityType<NonBurnableItemEntity>> NON_BURNABLE_ITEM = ENTITY_TYPES.register("non_burnable_item", () -> ForceEntities.register("non_burnable_item", EntityType.Builder.of(NonBurnableItemEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(6).updateInterval(20)));
    public static final Supplier<EntityType<ColdChickenEntity>> COLD_CHICKEN = ENTITY_TYPES.register("cold_chicken", () -> ForceEntities.register("cold_chicken", EntityType.Builder.of(ColdChickenEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.4f, 0.7f).clientTrackingRange(10)));
    public static final Supplier<EntityType<ColdCowEntity>> COLD_COW = ENTITY_TYPES.register("cold_cow", () -> ForceEntities.register("cold_cow", EntityType.Builder.of(ColdCowEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).clientTrackingRange(10)));
    public static final Supplier<EntityType<ColdPigEntity>> COLD_PIG = ENTITY_TYPES.register("cold_pig", () -> ForceEntities.register("cold_pig", EntityType.Builder.of(ColdPigEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.9f).clientTrackingRange(10)));
    public static final Supplier<EntityType<FairyEntity>> FAIRY = ENTITY_TYPES.register("fairy", () -> ForceEntities.register("fairy", EntityType.Builder.of(FairyEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).clientTrackingRange(10)));
    public static final Supplier<EntityType<ChuChuEntity>> RED_CHU_CHU = ENTITY_TYPES.register("red_chu_chu", () -> ForceEntities.register("red_chu_chu", EntityType.Builder.of(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).sized(2.04f, 2.04f).clientTrackingRange(10)));
    public static final Supplier<EntityType<ChuChuEntity>> GREEN_CHU_CHU = ENTITY_TYPES.register("green_chu_chu", () -> ForceEntities.register("green_chu_chu", EntityType.Builder.of(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).sized(2.04f, 2.04f).clientTrackingRange(10)));
    public static final Supplier<EntityType<ChuChuEntity>> BLUE_CHU_CHU = ENTITY_TYPES.register("blue_chu_chu", () -> ForceEntities.register("blue_chu_chu", EntityType.Builder.of(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).sized(2.04f, 2.04f).clientTrackingRange(10)));
    public static final Supplier<EntityType<ChuChuEntity>> GOLD_CHU_CHU = ENTITY_TYPES.register("gold_chu_chu", () -> ForceEntities.register("gold_chu_chu", EntityType.Builder.of(ChuChuEntity::new, (MobCategory)MobCategory.MONSTER).sized(2.04f, 2.04f).clientTrackingRange(10)));
    public static final Supplier<EntityType<CreeperTotEntity>> CREEPER_TOT = ENTITY_TYPES.register("creeper_tot", () -> ForceEntities.register("creeper_tot", EntityType.Builder.of(CreeperTotEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.1f).clientTrackingRange(8)));
    public static final Supplier<EntityType<EnderTotEntity>> ENDER_TOT = ENTITY_TYPES.register("ender_tot", () -> ForceEntities.register("ender_tot", EntityType.Builder.of(EnderTotEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.6f).clientTrackingRange(8)));
    public static final Supplier<EntityType<AngryEndermanEntity>> ANGRY_ENDERMAN = ENTITY_TYPES.register("angry_enderman", () -> ForceEntities.register("angry_enderman", EntityType.Builder.of(AngryEndermanEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 2.9f).clientTrackingRange(8)));
    public static final Supplier<EntityType<ForceArrowEntity>> FORCE_ARROW = ENTITY_TYPES.register("force_arrow", () -> ForceEntities.register("force_arrow", EntityType.Builder.of(ForceArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20)));
    public static final Supplier<EntityType<FlaskEntity>> FORCE_FLASK = ENTITY_TYPES.register("force_flask", () -> ForceEntities.register("force_flask", EntityType.Builder.of(FlaskEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10)));

    public static void registerSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        event.register(RED_CHU_CHU.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(GREEN_CHU_CHU.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(BLUE_CHU_CHU.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(GOLD_CHU_CHU.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChuChuEntity::canSpawnHere, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(CREEPER_TOT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(ENDER_TOT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(ANGRY_ENDERMAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(FAIRY.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, FairyEntity::canSpawnOn, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(COLD_CHICKEN.get(), ColdChickenEntity.generateAttributes().build());
        event.put(COLD_COW.get(), ColdCowEntity.generateAttributes().build());
        event.put(COLD_PIG.get(), ColdPigEntity.generateAttributes().build());
        event.put(RED_CHU_CHU.get(), Monster.createMonsterAttributes().build());
        event.put(GREEN_CHU_CHU.get(), Monster.createMonsterAttributes().build());
        event.put(BLUE_CHU_CHU.get(), Monster.createMonsterAttributes().build());
        event.put(GOLD_CHU_CHU.get(), Monster.createMonsterAttributes().build());
        event.put(CREEPER_TOT.get(), CreeperTotEntity.generateAttributes().build());
        event.put(ENDER_TOT.get(), EnderTotEntity.generateAttributes().build());
        event.put(ANGRY_ENDERMAN.get(), AngryEndermanEntity.generateAttributes().build());
        event.put(FAIRY.get(), FairyEntity.generateAttributes().build());
    }

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return builder.build(id);
    }
}

