/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.ExperienceTomeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class TransmutationRecipe
implements CraftingRecipe {
    private final String group;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    public TransmutationRecipe(String groupIn, ItemStack result, NonNullList<Ingredient> ingredients) {
        this.group = groupIn;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.TRANSMUTATION_SERIALIZER.get();
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean isSpecial() {
        return false;
    }

    public boolean matches(CraftingInput inv, Level level) {
        StackedContents stackedContents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int stacks = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            ++stacks;
            if (itemstack.getItem() instanceof ForceRodItem) {
                if (this.isSimple) {
                    stackedContents.accountStack(itemstack, 1);
                    continue;
                }
                inputs.add(itemstack);
                continue;
            }
            if (itemstack.getItem() instanceof ExperienceTomeItem) {
                int experience = (Integer)itemstack.getOrDefault(ForceComponents.TOME_EXPERIENCE, (Object)0);
                if (itemstack.has(ForceComponents.TOME_EXPERIENCE) && experience < 100) {
                    return false;
                }
                ItemStack experienceTome = new ItemStack((ItemLike)ForceRegistry.EXPERIENCE_TOME.get());
                itemstack.set(ForceComponents.TOME_EXPERIENCE, (Object)experience);
                if (this.isSimple) {
                    stackedContents.accountStack(experienceTome, 1);
                    continue;
                }
                inputs.add(itemstack);
                continue;
            }
            if (itemstack.isDamaged()) continue;
            if (this.isSimple) {
                stackedContents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return stacks == this.ingredients.size() && (this.isSimple ? stackedContents.canCraft((Recipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack resultStack = this.getResultItem(registries).copy();
        for (int j = 0; j < inv.size(); ++j) {
            ItemEnchantments enchantmentMap;
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.is(ForceRegistry.EXPERIENCE_TOME) && itemstack.has(ForceComponents.TOME_EXPERIENCE)) {
                int experience = (Integer)itemstack.getOrDefault(ForceComponents.TOME_EXPERIENCE, (Object)0);
                int count = Math.min((int)((float)experience / 100.0f), 64);
                resultStack.setCount(count);
            }
            if (!(itemstack.getItem() instanceof EnchantedBookItem) || !(resultStack.getItem() instanceof ExperienceBottleItem) || (enchantmentMap = (ItemEnchantments)itemstack.get(DataComponents.ENCHANTMENTS)).isEmpty()) continue;
            int amount = 0;
            for (Map.Entry entry : enchantmentMap.entrySet()) {
                amount += ((Integer)entry.getValue()).intValue();
            }
            resultStack.setCount(Mth.clamp((int)amount, (int)1, (int)64));
        }
        return resultStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack1;
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (itemstack.getItem() instanceof ForceRodItem) {
                itemstack1 = itemstack.copy();
                ForceRodItem rod = (ForceRodItem)itemstack1.getItem();
                int damage = rod.damageItem(itemstack1, 1);
                if (itemstack1.getItem().getDamage(itemstack1) >= itemstack1.getMaxDamage()) {
                    itemstack1.shrink(1);
                    continue;
                }
                if (damage > 0) {
                    itemstack1.setDamageValue(itemstack1.getDamageValue() + damage);
                }
                nonnulllist.set(i, (Object)itemstack1);
                continue;
            }
            if (!(itemstack.getItem() instanceof ExperienceTomeItem)) continue;
            itemstack1 = itemstack.copy();
            int experience = (Integer)itemstack.getOrDefault(ForceComponents.TOME_EXPERIENCE, (Object)0);
            int count = (int)((float)experience / 100.0f);
            int newExperience = count > 64 ? experience - 6400 : experience - count * 100;
            itemstack1.set(ForceComponents.TOME_EXPERIENCE, (Object)newExperience);
            nonnulllist.set(i, (Object)itemstack1);
        }
        return nonnulllist;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<TransmutationRecipe> {
        private static final MapCodec<TransmutationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(array -> {
            Object[] aingredient = (Ingredient[])array.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for transmutation recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, TransmutationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TransmutationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TransmutationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TransmutationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static TransmutationRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new TransmutationRecipe(s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, TransmutationRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

