/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class FreezingRecipe
extends MultipleOutputFurnaceRecipe {
    public FreezingRecipe(String groupIn, Ingredient ingredientIn, NonNullList<ItemStack> results, float experience, int freezingTime) {
        super(ForceRecipes.FREEZING.get(), groupIn, ingredientIn, results, 1.0f, experience, freezingTime);
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ForceRegistry.FREEZING_CORE.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.FREEZING_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<FreezingRecipe> {
        private static final MapCodec<FreezingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> ((FreezingRecipe)recipe).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> ((FreezingRecipe)recipe).ingredient), (App)ItemStack.CODEC.listOf().fieldOf("results").flatXmap(array -> {
            Object[] stacks = (ItemStack[])array.toArray(ItemStack[]::new);
            if (stacks.length == 0) {
                return DataResult.error(() -> "No results for freezing recipe");
            }
            return stacks.length > MultipleOutputFurnaceRecipe.MAX_OUTPUT ? DataResult.error(() -> "Too many itemstacks for freezing recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)ItemStack.EMPTY, (Object[])stacks));
        }, DataResult::success).forGetter(recipe -> recipe.results), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(((FreezingRecipe)recipe).experience)), (App)Codec.INT.fieldOf("freezingTime").orElse((Object)200).forGetter(recipe -> ((FreezingRecipe)recipe).cookingTime)).apply((Applicative)instance, FreezingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FreezingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FreezingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FreezingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static FreezingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            NonNullList resultList = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            for (int j = 0; j < resultList.size(); ++j) {
                resultList.set(j, (Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer)));
            }
            float f = buffer.readFloat();
            int i = buffer.readVarInt();
            return new FreezingRecipe(s, ingredient, (NonNullList<ItemStack>)resultList, f, i);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, FreezingRecipe recipe) {
            buffer.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeVarInt(recipe.results.size());
            for (ItemStack stack : recipe.results) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)stack);
            }
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.cookingTime);
        }
    }
}

