/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu.infuser;

import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.menu.slot.SlotForceGems;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.util.AdvancementUtil;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class InfuserMenu
extends AbstractContainerMenu {
    private InfuserBlockEntity tile;
    private Player player;
    public final int[] validRecipe = new int[1];

    public InfuserMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, InfuserMenu.getTileEntity(playerInventory, data));
    }

    private static InfuserBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof InfuserBlockEntity) {
            return (InfuserBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public InfuserMenu(int id, Inventory playerInventoryIn, InfuserBlockEntity te) {
        super(ForceMenus.INFUSER.get(), id);
        this.tile = te;
        this.player = playerInventoryIn.player;
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 0, 80, 20));
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 1, 104, 32));
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 2, 116, 57));
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 3, 104, 81));
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 4, 80, 93));
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 5, 56, 81));
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 6, 44, 57));
        this.addSlot((Slot)new UnlockableSlot((IItemHandler)te.handler, 7, 56, 32));
        this.addSlot((Slot)new MatrixUpdatingSlot((IItemHandler)te.handler, 8, 80, 57));
        this.addSlot((Slot)new SlotForceGems((IItemHandler)te.handler, 9, 8, 23));
        this.addSlot((Slot)new MatrixUpdatingSlot((IItemHandler)te.handler, 10, 8, 5));
        int xPos = 8;
        int yPos = 127;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventoryIn, x, xPos + x * 18, yPos + 58));
        }
        this.trackPower();
        this.trackFluid();
        this.validRecipe[0] = this.tile.hasValidRecipe() ? 1 : 0;
        this.addDataSlot(DataSlot.shared((int[])this.validRecipe, (int)0));
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.tile.processTime;
            }

            public void set(int value) {
                InfuserMenu.this.tile.processTime = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.tile.maxProcessTime;
            }

            public void set(int value) {
                InfuserMenu.this.tile.maxProcessTime = value;
            }
        });
        AdvancementUtil.unlockTierAdvancements(this.player, this.tile.getBookTier());
    }

    private void trackFluid() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.tile.getFluidAmount() & 0xFFFF;
            }

            public void set(int value) {
                int fluidStored = InfuserMenu.this.tile.getFluidAmount() & 0xFFFF0000;
                InfuserMenu.this.tile.setFluidAmount(fluidStored + (value & 0xFFFF));
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.tile.getFluidAmount() >> 16 & 0xFFFF;
            }

            public void set(int value) {
                int fluidStored = InfuserMenu.this.tile.getFluidAmount() & 0xFFFF;
                InfuserMenu.this.tile.setFluidAmount(fluidStored | value << 16);
            }
        });
    }

    private void trackPower() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.tile.getEnergyStored() & 0xFFFF;
            }

            public void set(int value) {
                int energyStored = InfuserMenu.this.tile.getEnergyStored() & 0xFFFF0000;
                InfuserMenu.this.tile.setEnergyStored(energyStored + (value & 0xFFFF));
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return InfuserMenu.this.tile.getEnergyStored() >> 16 & 0xFFFF;
            }

            public void set(int value) {
                int energyStored = InfuserMenu.this.tile.getEnergyStored() & 0xFFFF;
                InfuserMenu.this.tile.setEnergyStored(energyStored | value << 16);
            }
        });
    }

    public boolean stillValid(Player playerIn) {
        return this.tile.stillValid(playerIn) && !playerIn.isSpectator();
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int tileSize = 11;
            if (index < 11 ? !this.moveItemStackTo(itemstack1, 11, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 11, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        this.slotsChanged(null);
        return itemstack;
    }

    public boolean isWorkAllowed() {
        return this.tile.isWorkAllowed();
    }

    public InfuserBlockEntity getTile() {
        return this.tile;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            this.getTile().startWork();
        }
        return super.clickMenuButton(player, id);
    }

    public void slotsChanged(Container inventoryIn) {
        if (inventoryIn != null) {
            super.slotsChanged(inventoryIn);
        }
        this.getTile().setChanged();
        this.validRecipe[0] = this.tile.updateValidRecipe() ? 1 : 0;
        AdvancementUtil.unlockTierAdvancements(this.player, this.tile.getBookTier());
    }

    public class UnlockableSlot
    extends MatrixUpdatingSlot {
        public UnlockableSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean isActive() {
            return this.slot <= InfuserMenu.this.tile.getBookTier();
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return this.slot <= InfuserMenu.this.tile.getBookTier() && super.mayPlace(stack);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    }

    public class MatrixUpdatingSlot
    extends SlotItemHandler {
        public MatrixUpdatingSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void setChanged() {
            super.setChanged();
            InfuserMenu.this.slotsChanged(null);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

