/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.card.RecipeContentsData;
import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemCardMenu
extends AbstractContainerMenu {
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResult = new ResultContainer();
    private final ContainerLevelAccess worldPosCallable;
    private final Player player;
    private ItemStack heldStack;

    public ItemCardMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.NULL);
    }

    public ItemCardMenu(int id, Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super(ForceMenus.ITEM_CARD.get(), id);
        RecipeContentsData recipeData;
        this.worldPosCallable = worldPosCallable;
        this.player = playerInventory.player;
        this.addSlot((Slot)new ResultSlot(this, playerInventory.player, this.craftMatrix, (Container)this.craftResult, 0, 124, 35){

            public boolean mayPickup(Player playerIn) {
                return false;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot(this, (Container)this.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18){

                    public int getMaxStackSize() {
                        return 1;
                    }

                    @NotNull
                    public void onTake(Player player, @NotNull ItemStack stack) {
                    }

                    @NotNull
                    public ItemStack remove(int par1) {
                        return ItemStack.EMPTY;
                    }

                    public boolean mayPlace(ItemStack par1ItemStack) {
                        return false;
                    }

                    public boolean mayPickup(Player par1PlayerEntity) {
                        return false;
                    }
                });
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 8 + l * 18, 142));
        }
        this.heldStack = ItemCardMenu.getCardStack(playerInventory);
        if (this.heldStack.getItem() == ForceRegistry.ITEM_CARD.get() && this.heldStack.has(ForceComponents.RECIPE_CONTENTS) && (recipeData = (RecipeContentsData)this.heldStack.get(ForceComponents.RECIPE_CONTENTS)) != null && !this.player.level().isClientSide) {
            for (int i = 0; i < this.craftMatrix.getContainerSize(); ++i) {
                this.craftMatrix.setItem(i, (ItemStack)recipeData.recipeItems().get(i));
            }
            this.craftResult.setItem(0, recipeData.resultItem());
        }
    }

    public static ItemStack getCardStack(Inventory playerInventory) {
        Player player = playerInventory.player;
        if (player.getMainHandItem().getItem() instanceof ItemCardItem) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().getItem() instanceof ItemCardItem) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    protected void updateCraftingResult(Level level, Player player, CraftingContainer inventory, ResultContainer inventoryResult) {
        if (!level.isClientSide) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Optional iRecipe = serverPlayer.server.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)inventory.asCraftInput(), level);
            if (iRecipe.isPresent() && (((CraftingRecipe)((RecipeHolder)iRecipe.get()).value()).isSpecial() || !level.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || serverPlayer.getRecipeBook().contains((RecipeHolder)iRecipe.get()) || player.isCreative())) {
                ItemStack stack = ((CraftingRecipe)((RecipeHolder)iRecipe.get()).value()).assemble((RecipeInput)this.craftMatrix.asCraftInput(), (HolderLookup.Provider)level.registryAccess());
                inventoryResult.setItem(0, stack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, 0, 0, stack));
            } else {
                inventoryResult.setItem(0, ItemStack.EMPTY);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, 0, 0, ItemStack.EMPTY));
            }
        }
    }

    public void slotsChanged(Container inventoryIn) {
        this.worldPosCallable.execute((world, pos) -> this.updateCraftingResult((Level)world, this.player, this.craftMatrix, this.craftResult));
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
    }

    public boolean stillValid(Player playerIn) {
        return !this.heldStack.isEmpty();
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int total_crafting_slots = 10;
        if (index <= 10) {
            return ItemStack.EMPTY;
        }
        int total_slots = 46;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index < 32 ? !this.moveItemStackTo(itemstack1, 32, 46, false) : index < 46 && !this.moveItemStackTo(itemstack1, 10, 32, false) || !this.moveItemStackTo(itemstack1, 10, 46, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
        }
        return itemstack;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 1 && slotId < 10) {
            if (clickTypeIn == ClickType.PICKUP || clickTypeIn == ClickType.PICKUP_ALL || clickTypeIn == ClickType.SWAP) {
                Slot slot = (Slot)this.slots.get(slotId);
                ItemStack dropping = this.getCarried();
                this.handleSlotClick(slot, dropping);
                return;
            }
            return;
        }
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack handleSlotClick(Slot slotId, ItemStack stack) {
        if (stack.getCount() > 0) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            slotId.set(copy);
        } else if (slotId.getItem().getCount() > 0) {
            slotId.set(ItemStack.EMPTY);
        }
        return slotId.getItem().copy();
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.craftResult && super.canTakeItemForPickAll(stack, slotIn);
    }

    public CraftingContainer getCraftMatrix() {
        return this.craftMatrix;
    }

    public ResultContainer getCraftResult() {
        return this.craftResult;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setMatrixContents(Player player, List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.handleSlotClick(this.getSlot(i), stacks.get(i));
        }
    }

    public List<ItemStack> getMatrixContents() {
        return null;
    }
}

