/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.card.RecipeContentsData;
import com.mrbysco.forcecraft.components.storage.PackStackHandler;
import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.util.FindingUtil;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ForcePackMenu
extends AbstractContainerMenu {
    private ItemStack heldStack;
    private int upgrades;
    private PackStackHandler inventory;

    public boolean stillValid(Player playerIn) {
        return !playerIn.isSpectator();
    }

    public static ForcePackMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        PackStackHandler handler = new PackStackHandler();
        handler.setUpgrades(data.readInt());
        return new ForcePackMenu(windowId, playerInventory, handler);
    }

    public ForcePackMenu(int id, Inventory playerInventory, PackStackHandler inv) {
        super(ForceMenus.FORCE_PACK.get(), id);
        this.heldStack = FindingUtil.findInstanceStack(playerInventory.player, stack -> stack.getItem() instanceof ForcePackItem);
        if (this.heldStack == null || this.heldStack.isEmpty()) {
            playerInventory.player.closeContainer();
            return;
        }
        this.inventory = inv;
        this.upgrades = 0;
        this.upgrades = this.inventory.getUpgrades();
        int numRows = this.upgrades + 1;
        int xPosC = 17;
        int yPosC = 20;
        for (int j = 0; j < numRows; ++j) {
            for (int k = 0; k < 8; ++k) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, k + j * 8, xPosC + k * 18, yPosC + j * 18){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return !(stack.getItem() instanceof ForcePackItem) && !(stack.getItem() instanceof ForceBeltItem);
                    }
                });
            }
        }
        int xPos = 8;
        int yPos = 36 + numRows * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, xPos + x * 18, yPos + 58));
        }
    }

    public void removed(Player player) {
        if (this.inventory != null) {
            if (player.level().isClientSide) {
                return;
            }
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (!(stack.getItem() instanceof ItemCardItem) || !stack.has(ForceComponents.RECIPE_CONTENTS)) continue;
                RecipeContentsData recipeData = (RecipeContentsData)stack.get(ForceComponents.RECIPE_CONTENTS);
                NonNullList ingredientList = NonNullList.create();
                ArrayList<ItemStack> mergeList = new ArrayList<ItemStack>();
                for (int j = 0; j < 9; ++j) {
                    ItemStack recipeStack = (ItemStack)recipeData.recipeItems().get(j);
                    if (recipeStack.isEmpty()) continue;
                    if (ingredientList.stream().noneMatch(s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)recipeStack))) {
                        ingredientList.add((Object)recipeStack.copy());
                        continue;
                    }
                    mergeList.add(recipeStack.copy());
                }
                for (ItemStack recipeStack : mergeList) {
                    if (ingredientList.isEmpty()) continue;
                    ArrayList<ItemStack> buffer = new ArrayList<ItemStack>();
                    if (recipeStack.getMaxStackSize() == 1) {
                        ingredientList.add((Object)recipeStack.copy());
                        recipeStack.shrink(1);
                        continue;
                    }
                    for (ItemStack ingredient : ingredientList) {
                        if (ingredient != null && !ingredient.isEmpty() && ingredient.getMaxStackSize() > 1 && ItemStack.isSameItemSameComponents((ItemStack)ingredient, (ItemStack)recipeStack)) {
                            int maxCount;
                            int addedCount = ingredient.getCount() + recipeStack.getCount();
                            if (addedCount <= (maxCount = ingredient.getMaxStackSize())) {
                                recipeStack.shrink(1);
                                ingredient.setCount(addedCount);
                            } else if (recipeStack.getCount() < maxCount) {
                                recipeStack.shrink(maxCount - ingredient.getCount());
                                ingredient.setCount(maxCount);
                            }
                        }
                        if (recipeStack.isEmpty()) continue;
                        buffer.add(recipeStack);
                    }
                    buffer.removeIf(ItemStack::isEmpty);
                    if (buffer.isEmpty()) continue;
                    ingredientList.addAll(buffer);
                }
                mergeList.clear();
                ArrayList<ItemStack> restList = new ArrayList<ItemStack>();
                for (int k = 0; k < this.inventory.getSlots(); ++k) {
                    ItemStack restStack;
                    if (k == i || (restStack = this.inventory.getStackInSlot(k)).isEmpty()) continue;
                    restList.add(restStack);
                }
                boolean canCraft = true;
                int craftCount = 64;
                for (ItemStack ingredient : ingredientList) {
                    int countPossible = 0;
                    for (ItemStack rest : restList) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)ingredient, (ItemStack)rest)) continue;
                        countPossible += (int)Math.floor((double)rest.getCount() / (double)ingredient.getCount());
                    }
                    if (countPossible == 0) {
                        canCraft = false;
                        craftCount = 0;
                        break;
                    }
                    if (countPossible >= craftCount) continue;
                    craftCount = countPossible;
                }
                ItemStack craftStack = recipeData.resultItem();
                if (!canCraft || craftCount <= 0) continue;
                for (int l = 0; l < craftCount; ++l) {
                    for (ItemStack ingredient : ingredientList) {
                        for (ItemStack rest : restList) {
                            if (!ItemStack.isSameItemSameComponents((ItemStack)ingredient, (ItemStack)rest) || rest.getCount() < ingredient.getCount()) continue;
                            if (rest.hasCraftingRemainingItem()) {
                                ItemStack remainderStack = rest.getCraftingRemainingItem().copy();
                                rest.shrink(1);
                                ItemStack insertResult = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)remainderStack, (boolean)false);
                                if (insertResult.isEmpty()) continue;
                                player.drop(insertResult, true);
                                continue;
                            }
                            rest.shrink(ingredient.getCount());
                        }
                    }
                    ItemStack stackCopy = craftStack.copy();
                    ItemStack craftedStack = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stackCopy, (boolean)false);
                    if (craftedStack.isEmpty()) continue;
                    player.drop(craftedStack, true);
                }
            }
            this.heldStack.set(ForceComponents.SLOTS_USED, (Object)ItemHandlerUtils.getUsedSlots((IItemHandler)this.inventory));
        }
        super.removed(player);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && this.getSlot(slotId).getItem().getItem() instanceof ForcePackItem) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public int getUpgrades() {
        return this.upgrades;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (itemstack.getItem() instanceof ForcePackItem) {
                return ItemStack.EMPTY;
            }
            int containerSlots = this.slots.size() - player.getInventory().items.size();
            if (index < containerSlots ? !this.moveItemStackTo(itemstack1, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

