/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.lootmodifiers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.registry.ForceLootModifiers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SmeltingModifier
extends LootModifier {
    public static final Supplier<MapCodec<SmeltingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> SmeltingModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SmeltingModifier::new)));

    public SmeltingModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList ret = new ObjectArrayList();
        generatedLoot.forEach(stack -> ret.add((Object)SmeltingModifier.smelt(stack, context)));
        return ret;
    }

    private static ItemStack smelt(ItemStack stack, LootContext context) {
        ItemStack ctxTool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        if (ctxTool == null) {
            return stack;
        }
        RegistryAccess registryAccess = context.getLevel().registryAccess();
        if (ctxTool.has(ForceComponents.TOOL_HEAT)) {
            return context.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)context.getLevel()).map(smeltRecipe -> ((SmeltingRecipe)smeltRecipe.value()).getResultItem((HolderLookup.Provider)registryAccess)).filter(itemStack -> !itemStack.isEmpty()).map(itemStack -> itemStack.copyWithCount(stack.getCount() * itemStack.getCount())).orElse(stack);
        }
        return stack;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return ForceLootModifiers.SMELTING.get();
    }
}

