/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceEffects;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;

public class MagnetGloveItem
extends BaseItem {
    public MagnetGloveItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        if (playerIn.isShiftKeyDown()) {
            ItemStack stack;
            boolean state = (Boolean)(stack = playerIn.getItemInHand(handIn)).getOrDefault(ForceComponents.MAGNET, (Object)false);
            stack.set(ForceComponents.MAGNET, (Object)(!state ? 1 : 0));
            level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return super.use(level, playerIn, handIn);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean state;
        if (entityIn instanceof Player && !(entityIn instanceof FakePlayer) && itemSlot >= 0 && itemSlot <= Inventory.getSelectionSize() && (state = ((Boolean)stack.getOrDefault(ForceComponents.MAGNET, (Object)false)).booleanValue())) {
            ((Player)entityIn).addEffect(new MobEffectInstance(ForceEffects.MAGNET, 20, 1, true, false));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (stack.has(ForceComponents.MAGNET)) {
            boolean activated = (Boolean)stack.getOrDefault(ForceComponents.MAGNET, (Object)false);
            if (activated) {
                tooltip.add((Component)Component.translatable((String)"forcecraft.magnet_glove.active").withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.translatable((String)"forcecraft.magnet_glove.deactivated").withStyle(ChatFormatting.RED));
            }
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"forcecraft.magnet_glove.change").withStyle(ChatFormatting.BOLD));
        }
    }
}

