/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.forcewrench.ForceWrenchData;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class ForceWrenchItem
extends BaseItem
implements IForceChargingTool {
    public ForceWrenchItem(Item.Properties name) {
        super(name.stacksTo(1).component(ForceComponents.WRENCH, (Object)ForceWrenchData.EMPTY));
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        if (stack.getItem() instanceof ForceWrenchItem) {
            if (player != null && player.isCrouching()) {
                ForceWrenchData attachment = (ForceWrenchData)stack.getOrDefault(ForceComponents.WRENCH, (Object)ForceWrenchData.EMPTY);
                if (level.getBlockEntity(pos) instanceof BlockEntity && !attachment.canStoreBlock()) {
                    return this.serializeNBT(level, pos, player, hand);
                }
                if (attachment.canStoreBlock()) {
                    this.placeBlockFromWrench(level, pos, player, hand, context.getClickedFace());
                }
            } else {
                ForceToolData fd = new ForceToolData(stack);
                if (fd.getForce() >= 10) {
                    BlockState state = level.getBlockState(pos);
                    if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        level.setBlockAndUpdate(pos, state.rotate((LevelAccessor)level, pos, Rotation.CLOCKWISE_90));
                        fd.setForce(fd.getForce() - 10);
                    }
                } else if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"forcecraft.wrench_rotate.insufficient", (Object[])new Object[]{10}).withStyle(ChatFormatting.RED), true);
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    private InteractionResult serializeNBT(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldWrench = player.getItemInHand(hand);
        ForceToolData fd = new ForceToolData(heldWrench);
        if (fd.getForce() >= 250) {
            BlockState state = level.getBlockState(pos);
            if (state.getPistonPushReaction() == PushReaction.BLOCK) {
                return InteractionResult.FAIL;
            }
            String blockName = state.getBlock().getDescriptionId();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                CompoundTag tag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                ForceWrenchData attachment = new ForceWrenchData(tag, state, blockName);
                level.removeBlockEntity(pos);
                heldWrench.set(ForceComponents.WRENCH, (Object)attachment);
            }
            fd.setForce(fd.getForce() - 250);
            BlockState airState = Blocks.AIR.defaultBlockState();
            level.setBlockAndUpdate(pos, airState);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.translatable((String)"forcecraft.wrench_transport.insufficient", (Object[])new Object[]{250}).withStyle(ChatFormatting.RED), true);
        return InteractionResult.FAIL;
    }

    private InteractionResult placeBlockFromWrench(Level level, BlockPos pos, Player player, InteractionHand hand, Direction side) {
        ItemStack heldWrench = player.getItemInHand(hand);
        ForceWrenchData attachment = (ForceWrenchData)heldWrench.get(ForceComponents.WRENCH);
        if (attachment.storedBlockState() != null) {
            Block block;
            BlockState state = attachment.storedBlockState();
            BlockPos offPos = pos.relative(side);
            level.setBlockAndUpdate(offPos, state);
            if (attachment.storedBlockNBT() != null && (block = state.getBlock()) instanceof EntityBlock) {
                EntityBlock entityBlock = (EntityBlock)block;
                CompoundTag blockTag = attachment.storedBlockNBT();
                BlockEntity be = entityBlock.newBlockEntity(offPos, state);
                if (be != null) {
                    be.loadWithComponents(blockTag, (HolderLookup.Provider)level.registryAccess());
                    be.setChanged();
                    level.setBlockEntity(be);
                    level.blockEntityChanged(offPos);
                } else if (blockTag != null) {
                    ForceCraft.LOGGER.error("Was unable to load block entity");
                }
            }
            heldWrench.remove(ForceComponents.WRENCH);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ForceWrenchData attachment;
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (stack.has(ForceComponents.WRENCH) && (attachment = (ForceWrenchData)stack.getOrDefault(ForceComponents.WRENCH, (Object)ForceWrenchData.EMPTY)).name() != null && !attachment.name().isEmpty()) {
            tooltip.add((Component)Component.literal((String)"Stored: ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)attachment.name()).withStyle(ChatFormatting.GRAY)));
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.damageItem(stack, amount);
    }
}

