/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.material.ModToolTiers;
import com.mrbysco.forcecraft.util.TooltipUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public class ForceSwordItem
extends SwordItem
implements IForceChargingTool {
    public ForceSwordItem(Item.Properties properties) {
        super(ModToolTiers.FORCE, properties.attributes(ForceSwordItem.createAttributes((Tier)ModToolTiers.FORCE, (int)-2, (float)-2.4f)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        boolean flag2;
        BlockHitResult traceResult;
        BlockPos lookPos;
        EntityTeleportEvent event;
        ItemStack heldStack = playerIn.getItemInHand(handIn);
        if (heldStack.has(ForceComponents.TOOL_WING)) {
            Vec3 vec = playerIn.getLookAngle();
            double wantedVelocity = 1.7;
            playerIn.setDeltaMovement(vec.x * wantedVelocity, vec.y * wantedVelocity, vec.z * wantedVelocity);
            heldStack.hurtAndBreak(1, (LivingEntity)playerIn, Player.getSlotForHand((InteractionHand)handIn));
            playerIn.getCooldowns().addCooldown((Item)this, 20);
            level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
        }
        if (heldStack.has(ForceComponents.TOOL_ENDER) && !((EntityTeleportEvent)NeoForge.EVENT_BUS.post((Event)(event = new EntityTeleportEvent((Entity)playerIn, (double)(lookPos = (traceResult = ForceSwordItem.getPlayerPOVHitResult((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE)).getBlockPos().relative(traceResult.getDirection())).getX(), (double)lookPos.getY(), (double)lookPos.getZ())))).isCanceled() && (flag2 = playerIn.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) && !playerIn.isSilent()) {
            level.playSound((Player)null, playerIn.xo, playerIn.yo, playerIn.zo, SoundEvents.ENDERMAN_TELEPORT, playerIn.getSoundSource(), 1.0f, 1.0f);
            playerIn.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            heldStack.hurtAndBreak(1, (LivingEntity)playerIn, Player.getSlotForHand((InteractionHand)handIn));
            playerIn.getCooldowns().addCooldown((Item)this, 10);
        }
        return super.use(level, playerIn, handIn);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        TooltipUtil.addForceTooltips(stack, tooltip);
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.damageItem(stack, amount);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

