/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.entities.ColdChickenEntity;
import com.mrbysco.forcecraft.entities.ColdCowEntity;
import com.mrbysco.forcecraft.entities.ColdPigEntity;
import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.TooltipUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ForceShearsItem
extends ShearsItem
implements IForceChargingTool {
    private static final int SET_FIRE_TIME = 10;
    private static final int SHEARS_DMG = 238;
    private static final Item[] WOOL = new Item[]{Items.RED_WOOL, Items.BLUE_WOOL, Items.BLACK_WOOL, Items.BLUE_WOOL, Items.BROWN_WOOL, Items.WHITE_WOOL, Items.ORANGE_WOOL, Items.MAGENTA_WOOL, Items.LIGHT_BLUE_WOOL, Items.YELLOW_WOOL, Items.LIME_WOOL, Items.PINK_WOOL, Items.GRAY_WOOL, Items.LIGHT_GRAY_WOOL, Items.CYAN_WOOL, Items.PURPLE_WOOL, Items.BROWN_WOOL, Items.GREEN_WOOL};

    public ForceShearsItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(952).component(DataComponents.TOOL, (Object)ForceShearsItem.createToolProperties()));
    }

    private ItemStack getRandomWool(Level level) {
        return new ItemStack((ItemLike)WOOL[Mth.nextInt((RandomSource)level.random, (int)0, (int)WOOL.length)]);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        BlockPos pos;
        Sheep target;
        Level level = entity.level();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        RandomSource rand = level.random;
        if (stack.has(ForceComponents.TOOL_RAINBOW) && entity instanceof Sheep && (target = (Sheep)entity).isShearable(playerIn, stack, level, pos = BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()))) {
            List drops = target.onSheared(playerIn, stack, level, pos);
            for (int i = 0; i < drops.size(); ++i) {
                ItemEntity ent = entity.spawnAtLocation(this.getRandomWool(level), 1.0f);
                if (ent == null) continue;
                ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            }
            stack.hurtAndBreak(1, (LivingEntity)playerIn, Player.getSlotForHand((InteractionHand)hand));
            return InteractionResult.SUCCESS;
        }
        boolean hasHeat = stack.has(ForceComponents.TOOL_HEAT);
        if (!(entity instanceof IColdMob)) {
            if (entity instanceof Cow) {
                Cow originalCow = (Cow)entity;
                if (!(entity instanceof MushroomCow)) {
                    int i = 1 + rand.nextInt(3);
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    for (int j = 0; j < i; ++j) {
                        drops.add(new ItemStack((ItemLike)Items.LEATHER, 1));
                    }
                    drops.forEach(d -> {
                        ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                        if (ent != null) {
                            ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                        }
                    });
                    entity.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
                    ColdCowEntity replacementMob = new ColdCowEntity(level, BuiltInRegistries.ENTITY_TYPE.getKey((Object)originalCow.getType()));
                    replacementMob.copyPosition((Entity)originalCow);
                    UUID mobUUID = replacementMob.getUUID();
                    replacementMob.restoreFrom((Entity)originalCow);
                    replacementMob.setUUID(mobUUID);
                    originalCow.remove(Entity.RemovalReason.DISCARDED);
                    level.addFreshEntity((Entity)replacementMob);
                    if (hasHeat) {
                        replacementMob.igniteForSeconds(10.0f);
                    }
                    stack.hurtAndBreak(1, (LivingEntity)playerIn, Player.getSlotForHand((InteractionHand)hand));
                    return InteractionResult.SUCCESS;
                }
            }
            if (entity instanceof Chicken) {
                Chicken originalChicken = (Chicken)entity;
                level = originalChicken.level();
                int i = 1 + rand.nextInt(3);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack((ItemLike)Items.FEATHER, 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
                entity.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
                ColdChickenEntity replacementMob = new ColdChickenEntity(level, BuiltInRegistries.ENTITY_TYPE.getKey((Object)originalChicken.getType()));
                replacementMob.copyPosition((Entity)originalChicken);
                UUID mobUUID = replacementMob.getUUID();
                replacementMob.restoreFrom((Entity)originalChicken);
                replacementMob.setUUID(mobUUID);
                originalChicken.remove(Entity.RemovalReason.DISCARDED);
                level.addFreshEntity((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.igniteForSeconds(10.0f);
                }
                stack.hurtAndBreak(1, (LivingEntity)playerIn, Player.getSlotForHand((InteractionHand)hand));
                return InteractionResult.SUCCESS;
            }
            if (entity instanceof Pig) {
                Pig originalPig = (Pig)entity;
                level = originalPig.level();
                int i = 1 + rand.nextInt(2);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack(hasHeat ? (ItemLike)ForceRegistry.COOKED_BACON.get() : (ItemLike)ForceRegistry.RAW_BACON.get(), 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
                entity.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
                ColdPigEntity replacementMob = new ColdPigEntity(level, BuiltInRegistries.ENTITY_TYPE.getKey((Object)originalPig.getType()));
                replacementMob.copyPosition((Entity)originalPig);
                UUID mobUUID = replacementMob.getUUID();
                replacementMob.restoreFrom((Entity)originalPig);
                replacementMob.setUUID(mobUUID);
                originalPig.remove(Entity.RemovalReason.DISCARDED);
                level.addFreshEntity((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.igniteForSeconds(10.0f);
                }
                stack.hurtAndBreak(1, entity, Player.getSlotForHand((InteractionHand)hand));
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactLivingEntity(stack, playerIn, entity, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        TooltipUtil.addForceTooltips(stack, tooltip);
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.damageItem(stack, amount);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

