/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.registry.material.ModToolTiers;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;

public class ForceMittItem
extends DiggerItem {
    private final Tier itemTier = ModToolTiers.FORCE;

    public ForceMittItem(Item.Properties properties) {
        super(ModToolTiers.FORCE, ForceTags.MINEABLE_WITH_MITTS, properties.attributes(ForceMittItem.createAttributes((Tier)ModToolTiers.FORCE, (float)3.0f, (float)-2.4f)).durability(1000));
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (state.is(BlockTags.LEAVES)) {
                BlockHitResult traceResult = ForceMittItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                switch (traceResult.getDirection().getAxis()) {
                    case X: {
                        this.breakBlockAt(player, level, stack, pos.above());
                        this.breakBlockAt(player, level, stack, pos.below());
                        this.breakBlockAt(player, level, stack, pos.north());
                        this.breakBlockAt(player, level, stack, pos.north().above());
                        this.breakBlockAt(player, level, stack, pos.north().below());
                        this.breakBlockAt(player, level, stack, pos.south());
                        this.breakBlockAt(player, level, stack, pos.south().above());
                        this.breakBlockAt(player, level, stack, pos.south().below());
                        break;
                    }
                    case Z: {
                        this.breakBlockAt(player, level, stack, pos.above());
                        this.breakBlockAt(player, level, stack, pos.below());
                        this.breakBlockAt(player, level, stack, pos.west());
                        this.breakBlockAt(player, level, stack, pos.west().above());
                        this.breakBlockAt(player, level, stack, pos.west().below());
                        this.breakBlockAt(player, level, stack, pos.east());
                        this.breakBlockAt(player, level, stack, pos.east().above());
                        this.breakBlockAt(player, level, stack, pos.east().below());
                        break;
                    }
                    case Y: {
                        this.breakBlockAt(player, level, stack, pos.north());
                        this.breakBlockAt(player, level, stack, pos.east());
                        this.breakBlockAt(player, level, stack, pos.west());
                        this.breakBlockAt(player, level, stack, pos.west().north());
                        this.breakBlockAt(player, level, stack, pos.west().east());
                        this.breakBlockAt(player, level, stack, pos.east());
                        this.breakBlockAt(player, level, stack, pos.east().north());
                        this.breakBlockAt(player, level, stack, pos.east().east());
                    }
                }
                level.playSound((Player)null, pos, (SoundEvent)ForceSounds.WHOOSH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.mineBlock(stack, level, state, pos, entityLiving);
    }

    public void breakBlockAt(Player player, Level level, ItemStack stack, BlockPos pos) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (level.getBlockState(pos).is(BlockTags.LEAVES)) {
            BlockState state = level.getBlockState(pos);
            if (!stack.isCorrectToolForDrops(state)) {
                return;
            }
            if (!level.isClientSide) {
                if (CommonHooks.fireBlockBreak((Level)level, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos, (BlockState)state).isCanceled()) {
                    return;
                }
                FluidState fluidState = level.getFluidState(pos);
                Block block = state.getBlock();
                if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                    block.playerWillDestroy(level, pos, state, player);
                    block.playerDestroy(level, player, pos, state, tileEntity, stack);
                    int exp = block.getExpDrop(state, (LevelAccessor)level, pos, null, (Entity)player, stack);
                    block.popExperience((ServerLevel)level, pos, exp);
                }
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
        }
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        Player player = context.getPlayer();
        ItemStack itemstack = context.getItemInHand();
        Pair pair = (Pair)HoeItem.TILLABLES.get(level.getBlockState(blockpos).getBlock());
        if (context.getClickedFace() != Direction.DOWN && level.isEmptyBlock(blockpos.above())) {
            if (pair == null) {
                return InteractionResult.PASS;
            }
            Predicate predicate = (Predicate)pair.getFirst();
            Consumer consumer = (Consumer)pair.getSecond();
            if (predicate.test(context)) {
                level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide) {
                    consumer.accept(context);
                    if (player != null) {
                        context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)context.getHand()));
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false));
        if (optional.isPresent()) {
            level.playSound(player, blockpos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
            level.setBlock(blockpos, optional.get(), 11);
            if (player != null) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)context.getHand()));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return state.is(ForceTags.MINEABLE_WITH_MITTS) ? 14.0f : 1.0f;
    }

    public float getAttackDamage() {
        return this.itemTier.getAttackDamageBonus();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, Player.getSlotForHand((InteractionHand)attacker.getUsedItemHand()));
        return true;
    }
}

