/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.google.common.collect.Lists;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.material.ModToolTiers;
import com.mrbysco.forcecraft.util.ForceUtils;
import com.mrbysco.forcecraft.util.TooltipUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.Nullable;

public class ForceAxeItem
extends AxeItem
implements IForceChargingTool {
    public ForceAxeItem(Item.Properties properties) {
        super(ModToolTiers.FORCE, properties.attributes(ForceAxeItem.createAttributes((Tier)ModToolTiers.FORCE, (float)0.0f, (float)-3.1f)));
    }

    public static boolean fellTree(ItemStack stack, BlockPos pos, Player player) {
        if (player.level().isClientSide) {
            return true;
        }
        NeoForge.EVENT_BUS.register((Object)new TreeChopTask(stack, pos, player, 10));
        return true;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        TooltipUtil.addForceTooltips(stack, tooltip);
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.damageItem(stack, amount);
    }

    public static class TreeChopTask {
        public final Level level;
        public final Player player;
        public final ItemStack tool;
        public final int blocksPerTick;
        public Queue<BlockPos> blocks = Lists.newLinkedList();
        public Set<BlockPos> visited = new HashSet<BlockPos>();

        public TreeChopTask(ItemStack tool, BlockPos start, Player player, int blocksPerTick) {
            this.level = player.level();
            this.player = player;
            this.tool = tool;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start.above());
        }

        @SubscribeEvent
        public void chop(LevelTickEvent.Post event) {
            Level level = event.getLevel();
            if (level.isClientSide()) {
                return;
            }
            if (!this.level.dimension().location().equals((Object)level.dimension().location())) {
                return;
            }
            int left = this.blocksPerTick;
            while (left > 0) {
                if (this.blocks.isEmpty()) {
                    this.finish();
                    return;
                }
                BlockPos pos = this.blocks.remove();
                if (!this.visited.add(pos) || !ForceUtils.isLog(level, pos)) continue;
                for (Direction facing : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
                    BlockPos pos2 = pos.relative(facing);
                    if (this.visited.contains(pos2)) continue;
                    this.blocks.add(pos2);
                }
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        BlockPos pos2 = pos.offset(-1 + x, 1, -1 + z);
                        if (this.visited.contains(pos2)) continue;
                        this.blocks.add(pos2);
                    }
                }
                ForceUtils.breakExtraBlock(this.tool, level, this.player, pos, pos);
                --left;
            }
        }

        private void finish() {
            NeoForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

