/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.infuser;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class UpgradeTomeItem
extends BaseItem {
    public UpgradeTomeItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        UpgradeBookData bd = (UpgradeBookData)stack.getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)UpgradeBookData.DEFAULT);
        MutableComponent tt = Component.translatable((String)"item.forcecraft.upgrade_tome.tt.tier");
        tt.withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA));
        tt.append(" " + String.valueOf((Object)bd.tier()));
        if (!bd.progressCache().isEmpty()) {
            tt.append(" : " + bd.progressCache());
        }
        tooltip.add((Component)tt);
        if (bd.tier() == UpgradeBookTier.FINAL) {
            tt = Component.translatable((String)"item.forcecraft.upgrade_tome.tt.max");
            tt.withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA));
        } else {
            tt = Component.translatable((String)"item.forcecraft.upgrade_tome.tt.points");
            tt.withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA));
            tt.append(" " + bd.points());
            tooltip.add((Component)tt);
            tt = Component.translatable((String)"item.forcecraft.upgrade_tome.tt.nexttier");
            tt.withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA));
            tt.append(" " + bd.nextTier(stack));
        }
        tooltip.add((Component)tt);
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"forcecraft.tooltip.press_shift"));
            return;
        }
        tooltip.add((Component)Component.translatable((String)"item.forcecraft.upgrade_tome.tt.point_info"));
        tt.withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA));
    }

    public static void onModifierApplied(ItemStack bookInSlot, ItemStack modifier, ItemStack tool) {
        UpgradeBookData.incrementPoints(bookInSlot, 25);
    }
}

