/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.infuser;

import com.mrbysco.forcecraft.components.ForceComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ForceToolData {
    private ItemStack stack;
    private int force = 0;

    public int getForce() {
        return this.force;
    }

    public void setForce(int force) {
        this.force = force;
    }

    public ForceToolData(ItemStack tool) {
        this.stack = tool;
        this.force = (Integer)tool.getOrDefault(ForceComponents.FORCE, (Object)0);
    }

    public void charge(int incoming) {
        this.force += incoming;
        this.stack.set(ForceComponents.FORCE, (Object)this.force);
    }

    public void attachInformation(List<Component> tooltip) {
        if (this.force > 0) {
            MutableComponent t = Component.translatable((String)"item.infuser.tooltip.forcelevel");
            t.append("" + this.force);
            t.withStyle(ChatFormatting.GOLD);
            tooltip.add((Component)t);
        }
    }
}

