/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.heart;

import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RecoveryHeartItem
extends BaseItem {
    public RecoveryHeartItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, level, entityIn, itemSlot, isSelected);
        if (!(entityIn instanceof Player)) {
            return;
        }
        Player player = (Player)entityIn;
        BlockPos pos = BlockPos.containing((double)player.getX(), (double)(player.getY() + player.getPassengerRidingPosition(entityIn).y()), (double)player.getZ());
        int HEAL_AMT = 2;
        for (int i = 0; i < stack.getCount(); ++i) {
            player.heal((float)HEAL_AMT);
            stack.shrink(1);
        }
        player.level().playSound((Player)null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)ForceSounds.HEART_PICKUP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        for (int i1 = 0; i1 < 15; ++i1) {
            double d0 = level.random.nextGaussian() * 0.02;
            double d1 = level.random.nextGaussian() * 0.02;
            double d2 = level.random.nextGaussian() * 0.02;
            level.addParticle((ParticleOptions)ParticleTypes.HEART, (double)((float)pos.getX() + level.random.nextFloat()), (double)pos.getY() + 1.0 + (double)level.random.nextFloat() * 2.0, (double)((float)pos.getZ() + level.random.nextFloat()), d0, d1, d2);
        }
    }
}

