/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.items.flask.ForceFilledForceFlask;
import com.mrbysco.forcecraft.items.flask.MilkFlaskItem;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import org.jetbrains.annotations.NotNull;

public class FlaskFluidHandler
extends FluidHandlerItemStackSimple {
    public FlaskFluidHandler(Supplier<DataComponentType<SimpleFluidContent>> componentType, ItemStack container) {
        super(componentType, container, 1000);
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @NotNull
    public FluidStack getFluid() {
        Item item = this.container.getItem();
        if (item instanceof ForceFilledForceFlask) {
            return new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 1000);
        }
        if (item instanceof MilkFlaskItem && NeoForgeMod.MILK.isBound()) {
            return new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public boolean canFillFluidType(FluidStack stack) {
        return stack.getFluid().is(ForceTags.FORCE) || NeoForgeMod.MILK.isBound() && stack.getFluid().is(ForceTags.MILK);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.canFillFluidType(stack);
    }

    protected void setContainerToEmpty() {
        this.container = new ItemStack((ItemLike)ForceRegistry.FORCE_FLASK.get());
    }

    protected void setFluid(FluidStack stack) {
        if (stack.isEmpty()) {
            this.setContainerToEmpty();
        } else {
            if (!stack.isEmpty() && stack.getFluid().is(ForceTags.FORCE)) {
                this.container = new ItemStack((ItemLike)ForceRegistry.FORCE_FILLED_FORCE_FLASK.get());
                return;
            }
            if (NeoForgeMod.MILK.isBound() && stack.getFluid().is(ForceTags.MILK)) {
                this.container = new ItemStack((ItemLike)ForceRegistry.MILK_FORCE_FLASK.get());
                return;
            }
        }
    }
}

