/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.flask.FlaskContent;
import com.mrbysco.forcecraft.entities.projectile.FlaskEntity;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityFlaskItem
extends BaseItem {
    public EntityFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public EntityFlaskItem(Item.Properties properties, EntityType<?> type) {
        this(properties.component(ForceComponents.FLASK_CONTENT, (Object)new FlaskContent(EntityType.getKey(type), new CompoundTag())));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player playerIn = context.getPlayer();
        if (level.isClientSide) {
            return InteractionResult.FAIL;
        }
        if (this.hasEntityStored(stack)) {
            Entity storedEntity = this.getStoredEntity(stack, level);
            BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
            storedEntity.absMoveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity(storedEntity);
            stack.remove(ForceComponents.FLASK_CONTENT);
        } else if (playerIn != null) {
            playerIn.sendSystemMessage((Component)Component.translatable((String)"item.entity_flask.empty2").withStyle(ChatFormatting.RED));
        }
        stack.shrink(1);
        ItemStack emptyFlask = new ItemStack((ItemLike)ForceRegistry.FORCE_FLASK.get());
        if (playerIn != null && !playerIn.getInventory().add(emptyFlask)) {
            playerIn.spawnAtLocation(emptyFlask, 0.0f);
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown() && !level.isClientSide()) {
            if (this.hasEntityStored(itemstack)) {
                level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                if (!level.isClientSide) {
                    FlaskEntity flaskEntity = new FlaskEntity(level, (LivingEntity)playerIn);
                    flaskEntity.setItem(itemstack);
                    flaskEntity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), -20.0f, 0.5f, 1.0f);
                    level.addFreshEntity((Entity)flaskEntity);
                }
                itemstack.consume(1, (LivingEntity)playerIn);
            } else {
                playerIn.sendSystemMessage((Component)Component.translatable((String)"item.entity_flask.empty").withStyle(ChatFormatting.RED));
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public boolean hasEntityStored(ItemStack stack) {
        return stack.has(ForceComponents.FLASK_CONTENT);
    }

    public Entity getStoredEntity(ItemStack stack, Level level) {
        FlaskContent content = (FlaskContent)stack.get(ForceComponents.FLASK_CONTENT);
        if (content == null) {
            return null;
        }
        ResourceLocation resourceLocation = content.storedType();
        if (resourceLocation == null) {
            return null;
        }
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
        if (type != null) {
            Entity entity = type.create(level);
            if (entity == null) {
                return null;
            }
            entity.load(content.entityData());
            return entity;
        }
        return null;
    }

    public void storeEntity(ItemStack stack, LivingEntity livingEntity) {
        CompoundTag entityData = livingEntity.saveWithoutId(new CompoundTag());
        FlaskContent content = new FlaskContent(EntityType.getKey((EntityType)livingEntity.getType()), entityData);
        stack.set(ForceComponents.FLASK_CONTENT, (Object)content);
        livingEntity.discard();
    }

    public boolean isBlacklisted(LivingEntity livingEntity) {
        return livingEntity.getType().is(ForceTags.FLASK_BLACKLIST);
    }

    public Component getName(ItemStack stack) {
        FlaskContent content = (FlaskContent)stack.get(ForceComponents.FLASK_CONTENT);
        if (content != null) {
            String mobTranslation = Util.makeDescriptionId((String)"entity", (ResourceLocation)content.storedType());
            return Component.translatable((String)super.getDescriptionId(stack), (Object[])new Object[]{Component.translatable((String)mobTranslation)});
        }
        return Component.translatable((String)super.getDescriptionId(stack), (Object[])new Object[]{"Empty"});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (this.hasEntityStored(stack)) {
            FlaskContent content = (FlaskContent)stack.get(ForceComponents.FLASK_CONTENT);
            tooltip.add((Component)Component.translatable((String)"item.entity_flask.tooltip").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.format("[%s]", content.storedType().toString())).withStyle(ChatFormatting.GRAY)));
            if (content.entityData().contains("Health")) {
                tooltip.add((Component)Component.translatable((String)"item.entity_flask.tooltip2").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.format("[%s]", content.entityData().getDouble("Health"))).withStyle(ChatFormatting.GRAY)));
            }
        }
    }
}

