/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.BaseItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FortuneItem
extends BaseItem {
    private static final Random random = new Random();

    public FortuneItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        String message = (String)stack.getOrDefault(ForceComponents.MESSAGE, (Object)"");
        if (message.isEmpty()) {
            FortuneItem.addMessage(stack);
            message = (String)stack.getOrDefault(ForceComponents.MESSAGE, (Object)"");
        }
        if (!level.isClientSide) {
            if (playerIn != null && playerIn.isShiftKeyDown()) {
                stack.consume(1, (LivingEntity)playerIn);
                ItemStack paperStack = new ItemStack((ItemLike)Items.PAPER);
                if (!playerIn.addItem(paperStack)) {
                    playerIn.spawnAtLocation(paperStack);
                }
            } else {
                playerIn.sendSystemMessage((Component)Component.literal((String)message));
            }
        }
        return super.use(level, playerIn, handIn);
    }

    public static void addMessage(ItemStack stack) {
        ArrayList messages = new ArrayList((Collection)ConfigHandler.COMMON.fortuneMessages.get());
        String message = "No fortune for you";
        if (!messages.isEmpty()) {
            int idx = random.nextInt(messages.size());
            message = (String)messages.get(idx);
        }
        stack.set(ForceComponents.MESSAGE, (Object)message);
    }
}

