/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities.projectile;

import com.mrbysco.forcecraft.items.flask.EntityFlaskItem;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FlaskEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    public FlaskEntity(EntityType<? extends FlaskEntity> typeIn, Level level) {
        super(typeIn, level);
    }

    public FlaskEntity(Level level, LivingEntity livingEntityIn) {
        super(ForceEntities.FORCE_FLASK.get(), livingEntityIn, level);
    }

    public FlaskEntity(Level level, double x, double y, double z) {
        super(ForceEntities.FORCE_FLASK.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return (Item)ForceRegistry.ENTITY_FLASK.get();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (this.level().isClientSide) return;
        ItemStack stack = this.getItem();
        Item item = stack.getItem();
        if (!(item instanceof EntityFlaskItem)) return;
        EntityFlaskItem forceFlask = (EntityFlaskItem)item;
        Entity entity = result.getEntity();
        if (forceFlask.hasEntityStored(stack)) {
            Entity storedEntity = forceFlask.getStoredEntity(stack, this.level());
            BlockPos pos = entity.blockPosition();
            storedEntity.absMoveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            this.level().addFreshEntity(storedEntity);
            this.setItem(new ItemStack((ItemLike)ForceRegistry.FORCE_FLASK.get()));
            return;
        }
        if (entity.isAlive() && !entity.isInvulnerable() && !(entity instanceof Player) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.canChangeDimensions(this.level(), entity.level()) && !forceFlask.isBlacklisted(livingEntity)) {
                ItemStack entityFlask = null;
                if (entity instanceof Bat) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.BAT_FLASK.get());
                } else if (entity instanceof Bee) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.BEE_FLASK.get());
                } else if (entity instanceof Cat) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.CAT_FLASK.get());
                } else if (entity instanceof Chicken) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.CHICKEN_FLASK.get());
                } else if (entity instanceof CaveSpider) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.CAVE_SPIDER_FLASK.get());
                } else if (entity instanceof Cod) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.COD_FLASK.get());
                } else if (entity instanceof Cow && !(entity instanceof MushroomCow)) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.COW_FLASK.get());
                } else if (entity instanceof Dolphin) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.DOLPHIN_FLASK.get());
                } else if (entity instanceof Donkey) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.DONKEY_FLASK.get());
                } else if (entity instanceof EnderMan) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.ENDERMAN_FLASK.get());
                } else if (entity instanceof Fox) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.FOX_FLASK.get());
                } else if (entity instanceof Horse) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.HORSE_FLASK.get());
                } else if (entity instanceof IronGolem) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.IRON_GOLEM_FLASK.get());
                } else if (entity instanceof Llama) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.LLAMA_FLASK.get());
                } else if (entity instanceof MushroomCow) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.MOOSHROOM_FLASK.get());
                } else if (entity instanceof Mule) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.MULE_FLASK.get());
                } else if (entity instanceof Panda) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.PANDA_FLASK.get());
                } else if (entity instanceof Parrot) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.PARROT_FLASK.get());
                } else if (entity instanceof Pig) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.PIG_FLASK.get());
                } else if (entity instanceof AbstractPiglin) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.PIGLIN_FLASK.get());
                } else if (entity instanceof PolarBear) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.POLAR_BEAR_FLASK.get());
                } else if (entity instanceof Pufferfish) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.PUFFERFISH_FLASK.get());
                } else if (entity instanceof Rabbit) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.RABBIT_FLASK.get());
                } else if (entity instanceof Salmon) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.SALMON_FLASK.get());
                } else if (entity instanceof Sheep) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.SHEEP_FLASK.get());
                } else if (entity instanceof AbstractSkeleton) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.SKELETON_FLASK.get());
                } else if (entity instanceof SnowGolem) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.SNOW_GOLEM_FLASK.get());
                } else if (entity instanceof Spider) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.SPIDER_FLASK.get());
                } else if (entity instanceof Squid) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.SQUID_FLASK.get());
                } else if (entity instanceof Strider) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.STRIDER_FLASK.get());
                } else if (entity instanceof TropicalFish) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.TROPICAL_FISH_FLASK.get());
                } else if (entity instanceof Turtle) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.TURTLE_FLASK.get());
                } else if (entity instanceof Villager) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.VILLAGER_FLASK.get());
                } else if (entity instanceof WanderingTrader) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.WANDERING_TRADER_FLASK.get());
                } else if (entity instanceof Wolf) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.WOLF_FLASK.get());
                } else if (entity instanceof ZombifiedPiglin) {
                    entityFlask = new ItemStack((ItemLike)ForceRegistry.ZOMBIFIED_PIGLIN_FLASK.get());
                }
                if (entityFlask != null) {
                    forceFlask.storeEntity(entityFlask, livingEntity);
                    this.setItem(entityFlask);
                    return;
                }
                forceFlask.storeEntity(stack, livingEntity);
                this.setItem(stack);
                return;
            }
        }
        this.setItem(new ItemStack((ItemLike)ForceRegistry.FORCE_FLASK.get()));
    }

    protected void onHitBlock(BlockHitResult result) {
        ItemStack stack;
        Item item;
        super.onHitBlock(result);
        if (!this.level().isClientSide && (item = (stack = this.getItem()).getItem()) instanceof EntityFlaskItem) {
            EntityFlaskItem forceFlask = (EntityFlaskItem)item;
            if (forceFlask.hasEntityStored(stack)) {
                Entity storedEntity = forceFlask.getStoredEntity(stack, this.level());
                BlockPos pos = result.getBlockPos().relative(result.getDirection());
                storedEntity.absMoveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                this.level().addFreshEntity(storedEntity);
            }
            this.setItem(new ItemStack((ItemLike)ForceRegistry.FORCE_FLASK.get()));
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.spawnAtLocation(this.getItem(), 0.5f);
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }
}

