/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities.goal;

import com.mrbysco.forcecraft.entities.IColdMob;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.neoforged.neoforge.event.EventHooks;

public class EatGrassToRestoreGoal
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStatePredicate.forBlock((Block)Blocks.GRASS_BLOCK);
    private final Mob grassEaterEntity;
    private final Level entityWorld;
    private int eatingGrassTimer;

    public EatGrassToRestoreGoal(Mob grassEaterEntityIn) {
        this.grassEaterEntity = grassEaterEntityIn;
        this.entityWorld = grassEaterEntityIn.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.grassEaterEntity.getRandom().nextInt(this.grassEaterEntity.isBaby() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = this.grassEaterEntity.blockPosition();
        if (IS_GRASS.test(this.entityWorld.getBlockState(blockpos))) {
            return true;
        }
        return this.entityWorld.getBlockState(blockpos.below()).is(Blocks.GRASS_BLOCK);
    }

    public void start() {
        this.eatingGrassTimer = 40;
        this.entityWorld.broadcastEntityEvent((Entity)this.grassEaterEntity, (byte)10);
        this.grassEaterEntity.getNavigation().stop();
    }

    public void stop() {
        this.eatingGrassTimer = 0;
    }

    public boolean canContinueToUse() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void tick() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.getEatingGrassTimer() == 4) {
            BlockPos blockpos = this.grassEaterEntity.blockPosition();
            if (IS_GRASS.test(this.entityWorld.getBlockState(blockpos))) {
                if (EventHooks.canEntityGrief((Level)this.entityWorld, (Entity)this.grassEaterEntity)) {
                    this.entityWorld.destroyBlock(blockpos, false);
                }
                this.transformMob();
            } else {
                BlockPos blockpos1 = blockpos.below();
                if (this.entityWorld.getBlockState(blockpos1).is(Blocks.GRASS_BLOCK)) {
                    if (EventHooks.canEntityGrief((Level)this.entityWorld, (Entity)this.grassEaterEntity)) {
                        this.entityWorld.levelEvent(2001, blockpos1, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                        this.entityWorld.setBlock(blockpos1, Blocks.DIRT.defaultBlockState(), 2);
                    }
                    this.transformMob();
                }
            }
        }
    }

    public void transformMob() {
        Mob mob = this.grassEaterEntity;
        if (mob instanceof IColdMob) {
            IColdMob coldMob = (IColdMob)mob;
            coldMob.transformMob((LivingEntity)this.grassEaterEntity, this.entityWorld);
        }
    }
}

