/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CreeperTotEntity
extends Creeper {
    public CreeperTotEntity(EntityType<? extends Creeper> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 4.0);
    }

    public EntityType<? extends Creeper> getType() {
        return ForceEntities.CREEPER_TOT.get();
    }

    public void explodeCreeper() {
        this.level().broadcastEntityEvent((Entity)this, (byte)17);
        if (!this.level().isClientSide) {
            this.dead = true;
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) && this.getRandom().nextInt(4) == 0) {
                this.spawnAtLocation(new ItemStack((ItemLike)ForceRegistry.PILE_OF_GUNPOWDER.get(), this.getRandom().nextInt(2) + 1));
            }
            this.discard();
        }
    }

    public void summonFireworkParticles(List<FireworkExplosion> fireworksTag, double yOffset) {
        if (fireworksTag != null) {
            Vec3 vector3d = this.getDeltaMovement();
            this.level().createFireworks(this.getX(), this.getY() + yOffset, this.getZ(), vector3d.x, vector3d.y, vector3d.z, fireworksTag);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 17 && this.level().isClientSide) {
            for (int i = 0; i < 4; ++i) {
                this.summonFireworkParticles(this.getFireworkTag(), 0.5);
            }
            this.summonFireworkParticles(this.getCreeperFireworkTag(), 2.5);
        }
        super.handleEntityEvent(id);
    }

    public List<FireworkExplosion> getFireworkTag() {
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        int[] colors = new int[16];
        for (int i = 0; i < 16; ++i) {
            colors[i] = DyeColor.byId((int)i).getFireworkColor();
        }
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.Shape.SMALL_BALL, IntList.of((int[])colors), IntList.of((int[])colors), false, true);
        explosions.add(explosion);
        return explosions;
    }

    public List<FireworkExplosion> getCreeperFireworkTag() {
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.Shape.CREEPER, IntList.of((int)DyeColor.LIME.getFireworkColor()), IntList.of((int)DyeColor.LIME.getFireworkColor()), false, true);
        explosions.add(explosion);
        return explosions;
    }
}

