/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.components.storage;

import com.mrbysco.forcecraft.components.storage.PackStackHandler;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PackStorage {
    private final UUID uuid;
    private final PackStackHandler inventory;

    public PackStorage(UUID uuid) {
        this.uuid = uuid;
        this.inventory = new PackStackHandler();
    }

    public PackStorage(CompoundTag tag, HolderLookup.Provider registries) {
        this.uuid = tag.getUUID("uuid");
        this.inventory = new PackStackHandler();
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public PackStackHandler getInventory() {
        return this.inventory;
    }

    public CompoundTag toNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("uuid", this.uuid);
        tag.putString("sUUID", this.uuid.toString());
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        return tag;
    }
}

