/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.components.storage;

import com.mrbysco.forcecraft.components.storage.StorageManager;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.registry.ForceTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PackStackHandler
extends ItemStackHandler {
    private static final int SLOTS_PER_UPGRADE = 8;
    private static final int MAX_UPGRADES = 4;
    public static final String NBT_UPGRADES = "Upgrades";
    private int upgrades;

    public PackStackHandler() {
        super(40);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return !(stack.getItem() instanceof ForcePackItem) && !stack.is(ForceTags.HOLDS_ITEMS) && super.isItemValid(slot, stack);
    }

    public int getSlotsInUse() {
        return (this.upgrades + 1) * 8;
    }

    public int getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(int upgrades) {
        this.upgrades = upgrades;
    }

    public void applyUpgrade() {
        ++this.upgrades;
        this.forceUpdate();
    }

    public void applyUpgrade(int upgrades) {
        this.upgrades += upgrades;
        this.forceUpdate();
    }

    public void applyDowngrade() {
        --this.upgrades;
        this.forceUpdate();
    }

    public void applyDowngrade(int upgrades) {
        this.upgrades -= upgrades;
        this.forceUpdate();
    }

    public void forceUpdate() {
        if (this.upgrades > 4) {
            this.upgrades = 4;
        }
        if (this.upgrades < 0) {
            this.upgrades = 0;
        }
        this.onContentsChanged(0);
    }

    protected void onContentsChanged(int slot) {
        StorageManager.getPacks().setDirty();
    }

    public boolean canUpgrade(UpgradeBookData bd) {
        if (this.upgrades >= 4) {
            return false;
        }
        if (bd.tier().asInt() >= UpgradeBookTier.TWO.asInt() && this.upgrades == 0) {
            return true;
        }
        if (bd.tier().asInt() >= UpgradeBookTier.THREE.asInt() && this.upgrades == 1) {
            return true;
        }
        if (bd.tier().asInt() >= UpgradeBookTier.FOUR.asInt() && this.upgrades == 2) {
            return true;
        }
        return bd.tier().asInt() >= UpgradeBookTier.FIVE.asInt() && this.upgrades == 3;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            nbtTagList.add((Object)((ItemStack)this.stacks.get(i)).save(provider, (Tag)itemTag));
        }
        CompoundTag tag = new CompoundTag();
        tag.put("Items", (Tag)nbtTagList);
        tag.putInt(NBT_UPGRADES, this.upgrades);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.setUpgrades(tag.contains(NBT_UPGRADES, 3) ? tag.getInt(NBT_UPGRADES) : this.upgrades);
        ListTag tagList = tag.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTags));
        }
        this.onLoad();
    }
}

